/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.analysis.toolbox;

import com.graphhopper.jsprit.analysis.toolbox.GraphStreamViewer;
import java.io.IOException;
import org.graphstream.graph.Graph;
import org.graphstream.stream.Sink;
import org.graphstream.stream.file.FileSourceDGS;
import org.graphstream.ui.view.Viewer;

public class AlgorithmEventsViewer {
    private double zoomFactor;
    private double scaling = 1.0;
    private long delayRecreation = 5L;
    private long delayRuin = 5L;

    public void setRecreationDelay(long delay_in_ms) {
        this.delayRecreation = delay_in_ms;
    }

    public void setRuinDelay(long delay_in_ms) {
        this.delayRuin = delay_in_ms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(String dgsFile) {
        System.setProperty("org.graphstream.ui.renderer", "org.graphstream.ui.j2dviewer.J2DGraphRenderer");
        Graph graph = GraphStreamViewer.createMultiGraph("g", GraphStreamViewer.StyleSheets.BLUE_FOREST);
        Viewer viewer = graph.display();
        viewer.disableAutoLayout();
        FileSourceDGS fs = new FileSourceDGS();
        fs.addSink((Sink)graph);
        DelayContainer delayContainer = new DelayContainer();
        DelaySink delaySink = new DelaySink(delayContainer);
        long delay = 2L;
        delaySink.setDelay(delay);
        delaySink.setRecreateDelay(this.delayRecreation);
        delaySink.setRuinDelay(this.delayRuin);
        fs.addSink((Sink)delaySink);
        try {
            fs.begin(dgsFile);
            while (fs.nextEvents()) {
                AlgorithmEventsViewer.sleep(delayContainer.delay);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fs.end();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            fs.removeSink((Sink)graph);
        }
    }

    public static void main(String[] args) {
        AlgorithmEventsViewer viewer = new AlgorithmEventsViewer();
        viewer.setRuinDelay(10L);
        viewer.setRecreationDelay(5L);
        viewer.display("output/events.dgs.gz");
    }

    private static void sleep(long renderDelay_in_ms2) {
        try {
            Thread.sleep(renderDelay_in_ms2);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static class DelaySink
    implements Sink {
        private DelayContainer delayContainer;
        private long delay = 2L;
        private long ruinDelay = 2L;
        private long recreateDelay = 2L;

        public DelaySink(DelayContainer delayContainer) {
            this.delayContainer = delayContainer;
        }

        public void setRuinDelay(long ruinDelay) {
            this.ruinDelay = ruinDelay;
        }

        public void setRecreateDelay(long recreateDelay) {
            this.recreateDelay = recreateDelay;
        }

        public void setDelay(long delay) {
            this.delay = delay;
        }

        public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        }

        public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        }

        public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        }

        public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        }

        public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        }

        public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        }

        public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        }

        public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        }

        public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        }

        public void nodeAdded(String sourceId, long timeId, String nodeId) {
        }

        public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        }

        public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        }

        public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        }

        public void graphCleared(String sourceId, long timeId) {
        }

        public void stepBegins(String sourceId, long timeId, double step) {
            if (step == 1.0) {
                this.delayContainer.delay = this.recreateDelay;
            }
            if (step == 0.0) {
                this.delayContainer.delay = this.ruinDelay;
            } else if (step == 3.0) {
                this.delayContainer.delay = this.delay;
            } else if (step == 2.0) {
                this.delayContainer.delay = this.delay;
            }
        }
    }

    private static class DelayContainer {
        long delay = 0L;

        private DelayContainer() {
        }
    }
}

