/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.analysis.toolbox;

import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class XYLineChartBuilder {
    private ConcurrentHashMap<String, XYSeries> seriesMap = new ConcurrentHashMap();
    private final String xDomain;
    private final String yDomain;
    private final String chartName;

    public static void saveChartAsPNG(JFreeChart chart, String pngFilename) {
        try {
            ChartUtilities.saveChartAsPNG((File)new File(pngFilename), (JFreeChart)chart, (int)1000, (int)600);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static XYLineChartBuilder newInstance(String chartTitle, String xDomainName, String yDomainName) {
        return new XYLineChartBuilder(chartTitle, xDomainName, yDomainName);
    }

    private XYLineChartBuilder(String chartName, String xDomainName, String yDomainName) {
        this.xDomain = xDomainName;
        this.yDomain = yDomainName;
        this.chartName = chartName;
    }

    public void addData(String seriesName, double xVal, double yVal) {
        if (!this.seriesMap.containsKey(seriesName)) {
            this.seriesMap.put(seriesName, new XYSeries((Comparable)((Object)seriesName), true, true));
        }
        this.seriesMap.get(seriesName).add(xVal, yVal);
    }

    public JFreeChart build() {
        XYSeriesCollection collection = new XYSeriesCollection();
        for (XYSeries s : this.seriesMap.values()) {
            collection.addSeries(s);
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)this.chartName, (String)this.xDomain, (String)this.yDomain, (XYDataset)collection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        return chart;
    }
}

