/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.analysis.toolbox;

import com.graphhopper.jsprit.core.algorithm.listener.AlgorithmEndsListener;
import com.graphhopper.jsprit.core.algorithm.listener.IterationStartsListener;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.BeforeJobInsertionListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionEndsListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionStartsListener;
import com.graphhopper.jsprit.core.algorithm.ruin.listener.RuinListener;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Delivery;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.Solutions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.Sink;
import org.graphstream.stream.file.FileSinkDGS;

public class AlgorithmEventsRecorder
implements RuinListener,
IterationStartsListener,
InsertionStartsListener,
BeforeJobInsertionListener,
InsertionEndsListener,
AlgorithmEndsListener {
    private boolean renderShipments = false;
    public static final int BEFORE_RUIN_RENDER_SOLUTION = 2;
    public static final int RUIN = 0;
    public static final int RECREATE = 1;
    public static final int CLEAR_SOLUTION = 3;
    private Graph graph;
    private FileSinkDGS fileSink;
    private FileOutputStream fos;
    private GZIPOutputStream gzipOs;
    private int start_recording_at = 0;
    private int end_recording_at = Integer.MAX_VALUE;
    private int currentIteration = 0;
    private VehicleRoutingProblem vrp;

    public AlgorithmEventsRecorder(VehicleRoutingProblem vrp, String dgsFileLocation) {
        this.vrp = vrp;
        this.graph = new MultiGraph("g");
        try {
            File dgsFile = new File(dgsFileLocation);
            this.fos = new FileOutputStream(dgsFile);
            this.fileSink = new FileSinkDGS();
            if (dgsFile.getName().endsWith("gz")) {
                this.gzipOs = new GZIPOutputStream(this.fos);
                this.fileSink.begin((OutputStream)this.gzipOs);
            } else {
                this.fileSink.begin((OutputStream)this.fos);
            }
            this.graph.addSink((Sink)this.fileSink);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.initialiseGraph(vrp);
    }

    public void setRecordingRange(int startIteration, int endIteration) {
        this.start_recording_at = startIteration;
        this.end_recording_at = endIteration;
    }

    public void ruinStarts(Collection<VehicleRoute> routes) {
        if (!this.record()) {
            return;
        }
        this.fileSink.stepBegins(this.graph.getId(), 0L, 2.0);
        this.markAllNodesAsInserted();
        this.addRoutes(routes);
        this.fileSink.stepBegins(this.graph.getId(), 0L, 0.0);
    }

    private void markAllNodesAsInserted() {
        for (Job j : this.vrp.getJobs().values()) {
            this.markInserted(j);
        }
    }

    private void addRoutes(Collection<VehicleRoute> routes) {
        for (VehicleRoute route : routes) {
            String prevNode = this.makeStartId(route.getVehicle());
            for (TourActivity act : route.getActivities()) {
                String actNodeId = this.getNodeId(act);
                this.addEdge(prevNode + "_" + actNodeId, prevNode, actNodeId);
                prevNode = actNodeId;
            }
            if (!route.getVehicle().isReturnToDepot()) continue;
            String lastNode = this.makeEndId(route.getVehicle());
            this.addEdge(prevNode + "_" + lastNode, prevNode, lastNode);
        }
    }

    private String getNodeId(TourActivity act) {
        String nodeId = null;
        if (act instanceof TourActivity.JobActivity) {
            Job job = ((TourActivity.JobActivity)act).getJob();
            if (job instanceof Service) {
                nodeId = job.getId();
            } else if (job instanceof Shipment) {
                nodeId = act.getName().equals("pickupShipment") ? this.getFromNodeId((Shipment)job) : this.getToNodeId((Shipment)job);
            }
        }
        return nodeId;
    }

    private boolean record() {
        return this.currentIteration >= this.start_recording_at && this.currentIteration <= this.end_recording_at;
    }

    public void ruinEnds(Collection<VehicleRoute> routes, Collection<Job> unassignedJobs) {
    }

    public void removed(Job job, VehicleRoute fromRoute) {
        if (!this.record()) {
            return;
        }
        if (job instanceof Service) {
            this.removeService(job, fromRoute);
        } else if (job instanceof Shipment) {
            this.removeShipment(job, fromRoute);
        }
    }

    private void removeShipment(Job job, VehicleRoute fromRoute) {
        Shipment shipment = (Shipment)job;
        String fromNodeId = this.getFromNodeId(shipment);
        String toNodeId = this.getToNodeId(shipment);
        Edge enteringToNode = this.getEnteringEdge(toNodeId);
        if (enteringToNode.getNode0().getId().equals(fromNodeId)) {
            this.markRemoved(this.graph.getNode(fromNodeId));
            this.markRemoved(this.graph.getNode(toNodeId));
            Edge enteringFromNode = this.getEnteringEdge(fromNodeId);
            this.removeEdge(enteringFromNode.getId());
            this.removeEdge(enteringToNode.getId());
            if (this.graph.getNode(toNodeId).getLeavingEdgeSet().isEmpty()) {
                if (fromRoute.getVehicle().isReturnToDepot()) {
                    throw new IllegalStateException("leaving edge is missing");
                }
                return;
            }
            Edge leavingToNode = this.getLeavingEdge(toNodeId);
            this.removeEdge(leavingToNode.getId());
            Node from = enteringFromNode.getNode0();
            Node to = leavingToNode.getNode1();
            if (!fromRoute.getActivities().isEmpty()) {
                this.addEdge(this.makeEdgeId(from, to), from.getId(), to.getId());
            }
        } else {
            this.removeNodeAndBelongingEdges(fromNodeId, fromRoute);
            this.removeNodeAndBelongingEdges(toNodeId, fromRoute);
        }
    }

    private Edge getLeavingEdge(String toNodeId) {
        Collection edges = this.graph.getNode(toNodeId).getLeavingEdgeSet();
        if (edges.size() == 1) {
            return (Edge)edges.iterator().next();
        }
        for (Edge e : edges) {
            if (e.getId().startsWith("shipment")) continue;
            return e;
        }
        return null;
    }

    private Edge getEnteringEdge(String toNodeId) {
        Collection enteringEdges = this.graph.getNode(toNodeId).getEnteringEdgeSet();
        if (enteringEdges.size() == 1) {
            return (Edge)enteringEdges.iterator().next();
        }
        for (Edge e : enteringEdges) {
            if (e.getId().startsWith("shipment")) continue;
            return e;
        }
        return null;
    }

    private String getToNodeId(Shipment shipment) {
        return shipment.getId() + "_delivery";
    }

    private String getFromNodeId(Shipment shipment) {
        return shipment.getId() + "_pickup";
    }

    private void removeService(Job job, VehicleRoute fromRoute) {
        String nodeId = job.getId();
        this.removeNodeAndBelongingEdges(nodeId, fromRoute);
    }

    private void removeNodeAndBelongingEdges(String nodeId, VehicleRoute fromRoute) {
        Node node = this.graph.getNode(nodeId);
        this.markRemoved(node);
        Edge entering = this.getEnteringEdge(nodeId);
        this.removeEdge(entering.getId());
        if (node.getLeavingEdgeSet().isEmpty()) {
            if (fromRoute.getVehicle().isReturnToDepot()) {
                throw new IllegalStateException("leaving edge is missing");
            }
            return;
        }
        Edge leaving = this.getLeavingEdge(nodeId);
        this.removeEdge(leaving.getId());
        Node from = entering.getNode0();
        Node to = leaving.getNode1();
        if (!fromRoute.getActivities().isEmpty()) {
            this.addEdge(this.makeEdgeId(from, to), from.getId(), to.getId());
        }
    }

    private void markRemoved(Node node) {
        node.setAttribute("ui.class", new Object[]{"removed"});
    }

    private String makeEdgeId(Node from, Node to) {
        return from.getId() + "_" + to.getId();
    }

    public void informAlgorithmEnds(VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        VehicleRoutingProblemSolution solution = Solutions.bestOf(solutions);
        this.fileSink.stepBegins(this.graph.getId(), 0L, 2.0);
        this.addRoutes(solution.getRoutes());
        this.finish();
    }

    private void finish() {
        try {
            this.fileSink.end();
            this.fos.close();
            if (this.gzipOs != null) {
                this.gzipOs.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void informIterationStarts(int i, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        this.currentIteration = i;
    }

    private void initialiseGraph(VehicleRoutingProblem problem) {
        for (Vehicle vehicle : problem.getVehicles()) {
            this.addVehicle(vehicle);
        }
        for (Job job : problem.getJobs().values()) {
            this.addJob(job);
        }
    }

    private void addJob(Job job) {
        if (job instanceof Service) {
            Service service = (Service)job;
            this.addNode(service.getId(), service.getLocation().getCoordinate());
            this.markService(service);
        } else if (job instanceof Shipment) {
            Shipment shipment = (Shipment)job;
            String fromNodeId = this.getFromNodeId(shipment);
            this.addNode(fromNodeId, shipment.getPickupLocation().getCoordinate());
            String toNodeId = this.getToNodeId(shipment);
            this.addNode(toNodeId, shipment.getDeliveryLocation().getCoordinate());
            this.markShipment(shipment);
            if (this.renderShipments) {
                Edge e = this.graph.addEdge("shipment_" + fromNodeId + "_" + toNodeId, fromNodeId, toNodeId, true);
                e.addAttribute("ui.class", new Object[]{"shipment"});
            }
        }
    }

    private void markShipment(Shipment shipment) {
        this.markPickup(this.getFromNodeId(shipment));
        this.markDelivery(this.getToNodeId(shipment));
    }

    private void markService(Service service) {
        if (service instanceof Delivery) {
            this.markDelivery(service.getId());
        } else {
            this.markPickup(service.getId());
        }
    }

    private void markPickup(String id) {
        this.graph.getNode(id).addAttribute("ui.class", new Object[]{"pickup"});
    }

    private void markDelivery(String id) {
        this.graph.getNode(id).addAttribute("ui.class", new Object[]{"delivery"});
    }

    private void addVehicle(Vehicle vehicle) {
        String startId = this.makeStartId(vehicle);
        Node node = this.graph.addNode(startId);
        node.addAttribute("x", new Object[]{vehicle.getStartLocation().getCoordinate().getX()});
        node.addAttribute("y", new Object[]{vehicle.getStartLocation().getCoordinate().getY()});
        node.addAttribute("ui.class", new Object[]{"depot"});
        String endId = this.makeEndId(vehicle);
        if (!startId.equals(endId)) {
            Node endNode = this.graph.addNode(endId);
            endNode.addAttribute("x", new Object[]{vehicle.getEndLocation().getCoordinate().getX()});
            endNode.addAttribute("y", new Object[]{vehicle.getEndLocation().getCoordinate().getY()});
            endNode.addAttribute("ui.class", new Object[]{"depot"});
        }
    }

    private String makeStartId(Vehicle vehicle) {
        return vehicle.getId() + "_start";
    }

    private String makeEndId(Vehicle vehicle) {
        if (vehicle.getStartLocation().getId().equals(vehicle.getEndLocation().getId())) {
            return this.makeStartId(vehicle);
        }
        return vehicle.getId() + "_end";
    }

    private void addNode(String nodeId, Coordinate nodeCoord) {
        Node node = this.graph.addNode(nodeId);
        node.addAttribute("x", new Object[]{nodeCoord.getX()});
        node.addAttribute("y", new Object[]{nodeCoord.getY()});
    }

    public void informInsertionEnds(Collection<VehicleRoute> vehicleRoutes, Collection<Job> badJobs) {
        if (!this.record()) {
            return;
        }
        this.fileSink.stepBegins(this.graph.getId(), 0L, 3.0);
        this.removeRoutes(vehicleRoutes);
    }

    private void removeRoutes(Collection<VehicleRoute> vehicleRoutes) {
        for (VehicleRoute route : vehicleRoutes) {
            String prevNode = this.makeStartId(route.getVehicle());
            for (TourActivity act : route.getActivities()) {
                String actNode = this.getNodeId(act);
                this.removeEdge(prevNode + "_" + actNode);
                prevNode = actNode;
            }
            if (!route.getVehicle().isReturnToDepot()) continue;
            String lastNode = this.makeEndId(route.getVehicle());
            this.removeEdge(prevNode + "_" + lastNode);
        }
    }

    public void informBeforeJobInsertion(Job job, InsertionData data, VehicleRoute route) {
        if (!this.record()) {
            return;
        }
        this.markInserted(job);
        this.handleVehicleSwitch(data, route);
        this.insertJob(job, data, route);
    }

    private void insertJob(Job job, InsertionData data, VehicleRoute route) {
        if (job instanceof Service) {
            this.insertService(job, data, route);
        } else if (job instanceof Shipment) {
            this.insertShipment(job, data, route);
        }
    }

    private void insertShipment(Job job, InsertionData data, VehicleRoute route) {
        String fromNodeId = this.getFromNodeId((Shipment)job);
        String toNodeId = this.getToNodeId((Shipment)job);
        this.insertNode(toNodeId, data.getDeliveryInsertionIndex(), data, route);
        List del = this.vrp.getActivities(job);
        VehicleRoute copied = VehicleRoute.copyOf((VehicleRoute)route);
        copied.getTourActivities().addActivity(data.getDeliveryInsertionIndex(), (TourActivity)del.get(1));
        this.insertNode(fromNodeId, data.getPickupInsertionIndex(), data, copied);
    }

    private void insertService(Job job, InsertionData data, VehicleRoute route) {
        this.insertNode(job.getId(), data.getDeliveryInsertionIndex(), data, route);
    }

    private void insertNode(String nodeId, int insertionIndex, InsertionData data, VehicleRoute route) {
        String node_j;
        String node_i;
        if (this.isFirst(insertionIndex)) {
            node_i = this.makeStartId(data.getSelectedVehicle());
        } else {
            TourActivity.JobActivity jobActivity = (TourActivity.JobActivity)route.getActivities().get(insertionIndex - 1);
            node_i = this.getNodeId((TourActivity)jobActivity);
        }
        String edgeId_1 = node_i + "_" + nodeId;
        if (this.isLast(insertionIndex, route)) {
            node_j = this.makeEndId(data.getSelectedVehicle());
        } else {
            TourActivity.JobActivity jobActivity = (TourActivity.JobActivity)route.getActivities().get(insertionIndex);
            node_j = this.getNodeId((TourActivity)jobActivity);
        }
        String edgeId_2 = nodeId + "_" + node_j;
        this.addEdge(edgeId_1, node_i, nodeId);
        if (!this.isLast(insertionIndex, route) || data.getSelectedVehicle().isReturnToDepot()) {
            this.addEdge(edgeId_2, nodeId, node_j);
            if (!route.getActivities().isEmpty()) {
                this.removeEdge(node_i + "_" + node_j);
            }
        }
    }

    private void handleVehicleSwitch(InsertionData data, VehicleRoute route) {
        boolean vehicleSwitch = false;
        if (!(route.getVehicle() instanceof VehicleImpl.NoVehicle) && !route.getVehicle().getId().equals(data.getSelectedVehicle().getId())) {
            vehicleSwitch = true;
        }
        if (vehicleSwitch && !route.getActivities().isEmpty()) {
            String oldStart = this.makeStartId(route.getVehicle());
            String firstAct = ((TourActivity.JobActivity)route.getActivities().get(0)).getJob().getId();
            String oldEnd = this.makeEndId(route.getVehicle());
            String lastAct = ((TourActivity.JobActivity)route.getActivities().get(route.getActivities().size() - 1)).getJob().getId();
            this.removeEdge(oldStart + "_" + firstAct);
            if (route.getVehicle().isReturnToDepot()) {
                this.removeEdge(lastAct + "_" + oldEnd);
            }
            String newStart = this.makeStartId(data.getSelectedVehicle());
            String newEnd = this.makeEndId(data.getSelectedVehicle());
            this.addEdge(newStart + "_" + firstAct, newStart, firstAct);
            if (data.getSelectedVehicle().isReturnToDepot()) {
                this.addEdge(lastAct + "_" + newEnd, lastAct, newEnd);
            }
        }
    }

    private void markInserted(Job job) {
        if (job instanceof Service) {
            this.markService((Service)job);
        } else {
            this.markShipment((Shipment)job);
        }
    }

    private void removeEdge(String edgeId) {
        this.markEdgeRemoved(edgeId);
        this.graph.removeEdge(edgeId);
    }

    private void markEdgeRemoved(String edgeId) {
        this.graph.getEdge(edgeId).addAttribute("ui.class", new Object[]{"removed"});
    }

    private boolean isFirst(int index) {
        return index == 0;
    }

    private boolean isLast(int index, VehicleRoute route) {
        return index == route.getActivities().size();
    }

    private void addEdge(String edgeId, String fromNode, String toNode) {
        this.graph.addEdge(edgeId, fromNode, toNode, true);
        this.markEdgeInserted(edgeId);
    }

    private void markEdgeInserted(String edgeId) {
        this.graph.getEdge(edgeId).addAttribute("ui.class", new Object[]{"inserted"});
        this.graph.getEdge(edgeId).removeAttribute("ui.class");
    }

    public void informInsertionStarts(Collection<VehicleRoute> vehicleRoutes, Collection<Job> unassignedJobs) {
        if (!this.record()) {
            return;
        }
        this.fileSink.stepBegins(this.graph.getId(), 0L, 1.0);
    }
}

