/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.analysis.toolbox;

import com.graphhopper.jsprit.analysis.toolbox.XYLineChartBuilder;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.listener.AlgorithmEndsListener;
import com.graphhopper.jsprit.core.algorithm.listener.AlgorithmStartsListener;
import com.graphhopper.jsprit.core.algorithm.listener.IterationEndsListener;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmSearchProgressChartListener
implements IterationEndsListener,
AlgorithmEndsListener,
AlgorithmStartsListener {
    private static Logger log = LoggerFactory.getLogger(AlgorithmSearchProgressChartListener.class);
    private String filename;
    private XYLineChartBuilder chartBuilder;

    public AlgorithmSearchProgressChartListener(String pngFileName) {
        this.filename = pngFileName;
        if (!this.filename.endsWith("png")) {
            this.filename = this.filename + ".png";
        }
    }

    public void informAlgorithmEnds(VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        log.info("create chart {}", (Object)this.filename);
        XYLineChartBuilder.saveChartAsPNG(this.chartBuilder.build(), this.filename);
    }

    public void informIterationEnds(int i, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        double worst = 0.0;
        double best = Double.MAX_VALUE;
        double sum = 0.0;
        for (VehicleRoutingProblemSolution sol : solutions) {
            if (sol.getCost() > worst) {
                worst = Math.min(sol.getCost(), Double.MAX_VALUE);
            }
            if (sol.getCost() < best) {
                best = sol.getCost();
            }
            sum += Math.min(sol.getCost(), Double.MAX_VALUE);
        }
        this.chartBuilder.addData("best", i, best);
        this.chartBuilder.addData("worst", i, worst);
        this.chartBuilder.addData("avg", i, sum / (double)solutions.size());
    }

    public void informAlgorithmStarts(VehicleRoutingProblem problem, VehicleRoutingAlgorithm algorithm, Collection<VehicleRoutingProblemSolution> solutions) {
        this.chartBuilder = XYLineChartBuilder.newInstance("search-progress", "iterations", "results");
    }
}

