/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.analysis.toolbox;

import com.graphhopper.jsprit.core.algorithm.SearchStrategy;
import com.graphhopper.jsprit.core.algorithm.listener.AlgorithmEndsListener;
import com.graphhopper.jsprit.core.algorithm.listener.IterationStartsListener;
import com.graphhopper.jsprit.core.algorithm.listener.StrategySelectedListener;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StrategyAnalyser
implements AlgorithmEndsListener,
StrategySelectedListener,
IterationStartsListener {
    private Map<String, Strategy> strategyMap = new HashMap<String, Strategy>();
    private Collection<VehicleRoutingProblemSolution> last;
    private Writer out;

    public void informIterationStarts(int i, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        this.last = new ArrayList<VehicleRoutingProblemSolution>(solutions);
    }

    public void informSelectedStrategy(SearchStrategy.DiscoveredSolution discoveredSolution, VehicleRoutingProblem vehicleRoutingProblem, Collection<VehicleRoutingProblemSolution> vehicleRoutingProblemSolutions) {
        String strategyId = discoveredSolution.getStrategyId();
        if (!this.strategyMap.containsKey(strategyId)) {
            this.strategyMap.put(strategyId, new Strategy(strategyId));
        }
        Strategy strategy = this.strategyMap.get(strategyId);
        strategy.selected();
        if (discoveredSolution.isAccepted()) {
            strategy.newSolution();
        }
        if (this.isBetter(vehicleRoutingProblemSolutions, this.last)) {
            strategy.improvedSolution(this.getImprovement(vehicleRoutingProblemSolutions, this.last));
        }
    }

    public void setOutWriter(Writer out) {
        this.out = out;
    }

    public void informAlgorithmEnds(VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        if (this.out == null) {
            this.out = new PrintWriter(System.out);
        }
        try {
            for (String stratId : this.strategyMap.keySet()) {
                Strategy strategy = this.strategyMap.get(stratId);
                this.out.write("id: " + stratId + ", #selected: " + strategy.getCountSelected() + ", #newSolutions: " + strategy.getCountNewSolution() + ", #improvedSolutions: " + strategy.getCountImproved() + ", improvements: " + strategy.getImprovements().toString() + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.out.flush();
                this.out.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private double getImprovement(Collection<VehicleRoutingProblemSolution> vehicleRoutingProblemSolutions, Collection<VehicleRoutingProblemSolution> last) {
        for (VehicleRoutingProblemSolution solution : vehicleRoutingProblemSolutions) {
            for (VehicleRoutingProblemSolution lastSolution : last) {
                if (!(solution.getCost() < lastSolution.getCost())) continue;
                return Math.round(lastSolution.getCost() - solution.getCost());
            }
        }
        return 0.0;
    }

    private boolean isBetter(Collection<VehicleRoutingProblemSolution> vehicleRoutingProblemSolutions, Collection<VehicleRoutingProblemSolution> last) {
        for (VehicleRoutingProblemSolution solution : vehicleRoutingProblemSolutions) {
            for (VehicleRoutingProblemSolution lastSolution : last) {
                if (!(solution.getCost() < lastSolution.getCost())) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, Strategy> getStrategies() {
        return this.strategyMap;
    }

    public static class Strategy {
        private final String id;
        private int selected = 0;
        private int improved = 0;
        private int countNewSolution = 0;
        private List<Double> improvements = new ArrayList<Double>();

        public Strategy(String id) {
            this.id = id;
        }

        public void selected() {
            ++this.selected;
        }

        public void improvedSolution(double improvement) {
            ++this.improved;
            this.improvements.add(improvement);
        }

        public void newSolution() {
            ++this.countNewSolution;
        }

        public String getId() {
            return this.id;
        }

        public int getCountSelected() {
            return this.selected;
        }

        public int getCountImproved() {
            return this.improved;
        }

        public int getCountNewSolution() {
            return this.countNewSolution;
        }

        public List<Double> getImprovements() {
            return this.improvements;
        }
    }
}

