/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm;

import com.graphhopper.jsprit.core.algorithm.recreate.InsertionStrategy;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.InitialSolutionFactory;
import com.graphhopper.jsprit.core.problem.solution.SolutionCostCalculator;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InsertionInitialSolutionFactory
implements InitialSolutionFactory {
    private static final Logger logger = LoggerFactory.getLogger(InsertionInitialSolutionFactory.class);
    private final InsertionStrategy insertion;
    private SolutionCostCalculator solutionCostsCalculator;

    public InsertionInitialSolutionFactory(InsertionStrategy insertionStrategy, SolutionCostCalculator solutionCostCalculator) {
        this.insertion = insertionStrategy;
        this.solutionCostsCalculator = solutionCostCalculator;
    }

    @Override
    public VehicleRoutingProblemSolution createSolution(VehicleRoutingProblem vrp) {
        logger.info("create initial solution");
        ArrayList<VehicleRoute> vehicleRoutes = new ArrayList<VehicleRoute>();
        vehicleRoutes.addAll(vrp.getInitialVehicleRoutes());
        Collection<Job> badJobs = this.insertion.insertJobs(vehicleRoutes, this.getUnassignedJobs(vrp));
        VehicleRoutingProblemSolution solution = new VehicleRoutingProblemSolution(vehicleRoutes, badJobs, Double.MAX_VALUE);
        double costs = this.solutionCostsCalculator.getCosts(solution);
        solution.setCost(costs);
        return solution;
    }

    private List<Job> getUnassignedJobs(VehicleRoutingProblem vrp) {
        ArrayList<Job> jobs = new ArrayList<Job>(vrp.getJobs().values());
        return jobs;
    }
}

