/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm;

import com.graphhopper.jsprit.core.algorithm.SearchStrategy;
import com.graphhopper.jsprit.core.algorithm.listener.SearchStrategyListener;
import com.graphhopper.jsprit.core.algorithm.listener.SearchStrategyModuleListener;
import com.graphhopper.jsprit.core.util.RandomNumberGeneration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchStrategyManager {
    private static final Logger logger = LoggerFactory.getLogger(SearchStrategyManager.class);
    private List<SearchStrategyListener> searchStrategyListeners = new ArrayList<SearchStrategyListener>();
    private List<SearchStrategy> strategies = new ArrayList<SearchStrategy>();
    private List<Double> weights = new ArrayList<Double>();
    private Map<String, Integer> id2index = new HashMap<String, Integer>();
    private Random random = RandomNumberGeneration.getRandom();
    private double sumWeights = 0.0;
    private int strategyIndex = 0;

    public void setRandom(Random random) {
        this.random = random;
    }

    public List<SearchStrategy> getStrategies() {
        return Collections.unmodifiableList(this.strategies);
    }

    public List<Double> getWeights() {
        return Collections.unmodifiableList(this.weights);
    }

    public double getWeight(String strategyId) {
        return this.weights.get(this.id2index.get(strategyId));
    }

    public void addStrategy(SearchStrategy strategy, double weight) {
        if (strategy == null) {
            throw new IllegalStateException("strategy is null. make sure adding a valid strategy.");
        }
        if (this.id2index.keySet().contains(strategy.getId())) {
            throw new IllegalStateException("strategyId " + strategy.getId() + " already in use. replace strateId in your config file or code with a unique strategy id");
        }
        if (weight < 0.0) {
            throw new IllegalStateException("weight is lower than zero.");
        }
        this.id2index.put(strategy.getId(), this.strategyIndex);
        ++this.strategyIndex;
        this.strategies.add(strategy);
        this.weights.add(weight);
        this.sumWeights += weight;
    }

    public void informStrategyWeightChanged(String strategyId, double weight) {
        int strategyIndex = this.id2index.get(strategyId);
        this.weights.set(strategyIndex, weight);
        this.updateSumWeights();
    }

    private void updateSumWeights() {
        double sum = 0.0;
        for (double w : this.weights) {
            sum += w;
        }
        this.sumWeights = sum;
    }

    public SearchStrategy getRandomStrategy() {
        if (this.random == null) {
            throw new IllegalStateException("randomizer is null. make sure you set random object correctly");
        }
        double randomFig = this.random.nextDouble();
        double sumProbabilities = 0.0;
        for (int i = 0; i < this.weights.size(); ++i) {
            if (!(randomFig < (sumProbabilities += this.weights.get(i) / this.sumWeights))) continue;
            return this.strategies.get(i);
        }
        throw new IllegalStateException("no search-strategy found");
    }

    public void addSearchStrategyListener(SearchStrategyListener strategyListener) {
        this.searchStrategyListeners.add(strategyListener);
    }

    public void addSearchStrategyModuleListener(SearchStrategyModuleListener moduleListener) {
        for (SearchStrategy s : this.strategies) {
            s.addModuleListener(moduleListener);
        }
    }
}

