/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm;

import com.graphhopper.jsprit.core.algorithm.SearchStrategy;
import com.graphhopper.jsprit.core.algorithm.SearchStrategyManager;
import com.graphhopper.jsprit.core.algorithm.listener.SearchStrategyListener;
import com.graphhopper.jsprit.core.algorithm.listener.SearchStrategyModuleListener;
import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListener;
import com.graphhopper.jsprit.core.algorithm.listener.VehicleRoutingAlgorithmListeners;
import com.graphhopper.jsprit.core.algorithm.termination.PrematureAlgorithmTermination;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.SolutionCostCalculator;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.util.Solutions;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleRoutingAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(VehicleRoutingAlgorithm.class);
    private final Counter counter = new Counter("iterations ");
    private final VehicleRoutingProblem problem;
    private final SearchStrategyManager searchStrategyManager;
    private final VehicleRoutingAlgorithmListeners algoListeners = new VehicleRoutingAlgorithmListeners();
    private final Collection<VehicleRoutingProblemSolution> initialSolutions;
    private int maxIterations = 100;
    private TerminationManager terminationManager = new TerminationManager();
    private VehicleRoutingProblemSolution bestEver = null;
    private final SolutionCostCalculator objectiveFunction;

    public VehicleRoutingAlgorithm(VehicleRoutingProblem problem, SearchStrategyManager searchStrategyManager) {
        this.problem = problem;
        this.searchStrategyManager = searchStrategyManager;
        this.initialSolutions = new ArrayList<VehicleRoutingProblemSolution>();
        this.objectiveFunction = null;
    }

    public VehicleRoutingAlgorithm(VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> initialSolutions, SearchStrategyManager searchStrategyManager) {
        this.problem = problem;
        this.searchStrategyManager = searchStrategyManager;
        this.initialSolutions = initialSolutions;
        this.objectiveFunction = null;
    }

    public VehicleRoutingAlgorithm(VehicleRoutingProblem problem, SearchStrategyManager searchStrategyManager, SolutionCostCalculator objectiveFunction) {
        this.problem = problem;
        this.searchStrategyManager = searchStrategyManager;
        this.initialSolutions = new ArrayList<VehicleRoutingProblemSolution>();
        this.objectiveFunction = objectiveFunction;
    }

    public void addInitialSolution(VehicleRoutingProblemSolution solution) {
        this.verify(solution);
        this.initialSolutions.add(solution);
    }

    private void verify(VehicleRoutingProblemSolution solution) {
        int nuJobs = 0;
        for (VehicleRoute route : solution.getRoutes()) {
            nuJobs += route.getTourActivities().getJobs().size();
            if (route.getVehicle().getIndex() == 0) {
                throw new IllegalStateException("vehicle used in initial solution has no index. probably a vehicle is used that has not been added to the  the VehicleRoutingProblem. only use vehicles that have already been added to the problem.");
            }
            for (TourActivity act : route.getActivities()) {
                if (act.getIndex() != 0) continue;
                throw new IllegalStateException("act in initial solution has no index. activities are created and associated to their job in VehicleRoutingProblem\n. thus if you build vehicle-routes use the jobActivityFactory from vehicle routing problem like that \n VehicleRoute.Builder.newInstance(knownVehicle).setJobActivityFactory(vrp.getJobActivityFactory).addService(..)....build() \n then the activities that are created to build the route are identical to the ones used in VehicleRoutingProblem");
            }
        }
        if (nuJobs != this.problem.getJobs().values().size()) {
            logger.warn("number of jobs in initial solution ({}) is not equal nuJobs in vehicle routing problem ({})\n this might yield unintended effects, e.g. initial solution cannot be improved anymore.", (Object)nuJobs, (Object)this.problem.getJobs().values().size());
        }
    }

    public void setPrematureAlgorithmTermination(PrematureAlgorithmTermination prematureAlgorithmTermination) {
        this.terminationManager = new TerminationManager();
        this.terminationManager.addTermination(prematureAlgorithmTermination);
    }

    public void addTerminationCriterion(PrematureAlgorithmTermination terminationCriterion) {
        this.terminationManager.addTermination(terminationCriterion);
    }

    public SearchStrategyManager getSearchStrategyManager() {
        return this.searchStrategyManager;
    }

    public Collection<VehicleRoutingProblemSolution> searchSolutions() {
        logger.info("algorithm starts: [maxIterations={}]", (Object)this.maxIterations);
        double now = System.currentTimeMillis();
        int noIterationsThisAlgoIsRunning = this.maxIterations;
        this.counter.reset();
        ArrayList<VehicleRoutingProblemSolution> solutions = new ArrayList<VehicleRoutingProblemSolution>(this.initialSolutions);
        this.algorithmStarts(this.problem, solutions);
        this.bestEver = Solutions.bestOf(solutions);
        if (logger.isTraceEnabled()) {
            this.log(solutions);
        }
        logger.info("iterations start");
        for (int i = 0; i < this.maxIterations; ++i) {
            this.iterationStarts(i + 1, this.problem, solutions);
            logger.debug("start iteration: {}", (Object)i);
            this.counter.incCounter();
            SearchStrategy strategy = this.searchStrategyManager.getRandomStrategy();
            SearchStrategy.DiscoveredSolution discoveredSolution = strategy.run(this.problem, solutions);
            if (logger.isTraceEnabled()) {
                this.log(discoveredSolution);
            }
            this.memorizeIfBestEver(discoveredSolution);
            this.selectedStrategy(discoveredSolution, this.problem, solutions);
            if (this.terminationManager.isPrematureBreak(discoveredSolution)) {
                logger.info("premature algorithm termination at iteration {}", (Object)(i + 1));
                noIterationsThisAlgoIsRunning = i + 1;
                break;
            }
            this.iterationEnds(i + 1, this.problem, solutions);
        }
        logger.info("iterations end at {} iterations", (Object)noIterationsThisAlgoIsRunning);
        this.addBestEver(solutions);
        this.algorithmEnds(this.problem, solutions);
        logger.info("took {} seconds", (Object)(((double)System.currentTimeMillis() - now) / 1000.0));
        return solutions;
    }

    private void addBestEver(Collection<VehicleRoutingProblemSolution> solutions) {
        if (this.bestEver != null) {
            solutions.add(this.bestEver);
        }
    }

    private void log(Collection<VehicleRoutingProblemSolution> solutions) {
        for (VehicleRoutingProblemSolution sol : solutions) {
            this.log(sol);
        }
    }

    private void log(VehicleRoutingProblemSolution solution) {
        logger.trace("solution costs: {}", (Object)solution.getCost());
        for (VehicleRoute r : solution.getRoutes()) {
            StringBuilder b = new StringBuilder();
            b.append(r.getVehicle().getId()).append(" : ").append("[ ");
            for (TourActivity act : r.getActivities()) {
                if (!(act instanceof TourActivity.JobActivity)) continue;
                b.append(((TourActivity.JobActivity)act).getJob().getId()).append(" ");
            }
            b.append("]");
            logger.trace(b.toString());
        }
        StringBuilder b = new StringBuilder();
        b.append("unassigned : [ ");
        for (Job j : solution.getUnassignedJobs()) {
            b.append(j.getId()).append(" ");
        }
        b.append("]");
        logger.trace(b.toString());
    }

    private void log(SearchStrategy.DiscoveredSolution discoveredSolution) {
        logger.trace("discovered solution: {}", (Object)discoveredSolution);
        this.log(discoveredSolution.getSolution());
    }

    private void memorizeIfBestEver(SearchStrategy.DiscoveredSolution discoveredSolution) {
        if (discoveredSolution == null) {
            return;
        }
        if (this.bestEver == null) {
            this.bestEver = discoveredSolution.getSolution();
        } else if (discoveredSolution.getSolution().getCost() < this.bestEver.getCost()) {
            this.bestEver = discoveredSolution.getSolution();
        }
    }

    private void selectedStrategy(SearchStrategy.DiscoveredSolution discoveredSolution, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        this.algoListeners.selectedStrategy(discoveredSolution, problem, solutions);
    }

    private void algorithmEnds(VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        this.algoListeners.algorithmEnds(problem, solutions);
    }

    public VehicleRoutingAlgorithmListeners getAlgorithmListeners() {
        return this.algoListeners;
    }

    public void addListener(VehicleRoutingAlgorithmListener l) {
        this.algoListeners.addListener(l);
        if (l instanceof SearchStrategyListener) {
            this.searchStrategyManager.addSearchStrategyListener((SearchStrategyListener)l);
        }
        if (l instanceof SearchStrategyModuleListener) {
            this.searchStrategyManager.addSearchStrategyModuleListener((SearchStrategyModuleListener)l);
        }
    }

    private void iterationEnds(int i, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        this.algoListeners.iterationEnds(i, problem, solutions);
    }

    private void iterationStarts(int i, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        this.algoListeners.iterationStarts(i, problem, solutions);
    }

    private void algorithmStarts(VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        this.algoListeners.algorithmStarts(problem, this, solutions);
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
        logger.debug("set maxIterations to {}", (Object)this.maxIterations);
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public SolutionCostCalculator getObjectiveFunction() {
        return this.objectiveFunction;
    }

    private static class Counter {
        private final String name;
        private long counter = 0L;
        private long nextCounter = 1L;
        private static final Logger log = LoggerFactory.getLogger(Counter.class);

        public Counter(String name) {
            this.name = name;
        }

        public void incCounter() {
            long i;
            long n = this.nextCounter;
            if ((i = ++this.counter) >= n) {
                this.nextCounter = n * 2L;
                log.info(this.name + n);
            }
        }

        public void reset() {
            this.counter = 0L;
            this.nextCounter = 1L;
        }
    }

    private static class TerminationManager
    implements PrematureAlgorithmTermination {
        private Collection<PrematureAlgorithmTermination> terminationCriteria = new ArrayList<PrematureAlgorithmTermination>();

        private TerminationManager() {
        }

        void addTermination(PrematureAlgorithmTermination termination) {
            this.terminationCriteria.add(termination);
        }

        @Override
        public boolean isPrematureBreak(SearchStrategy.DiscoveredSolution discoveredSolution) {
            for (PrematureAlgorithmTermination termination : this.terminationCriteria) {
                if (!termination.isPrematureBreak(discoveredSolution)) continue;
                return true;
            }
            return false;
        }
    }
}

