/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.module;

import com.graphhopper.jsprit.core.algorithm.SearchStrategyModule;
import com.graphhopper.jsprit.core.algorithm.listener.SearchStrategyModuleListener;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionStrategy;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionListener;
import com.graphhopper.jsprit.core.algorithm.ruin.RuinStrategy;
import com.graphhopper.jsprit.core.algorithm.ruin.listener.RuinListener;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import java.util.Collection;
import java.util.HashSet;

public class RuinAndRecreateModule
implements SearchStrategyModule {
    private InsertionStrategy insertion;
    private RuinStrategy ruin;
    private String moduleName;

    public RuinAndRecreateModule(String moduleName, InsertionStrategy insertion, RuinStrategy ruin) {
        this.insertion = insertion;
        this.ruin = ruin;
        this.moduleName = moduleName;
    }

    @Override
    public VehicleRoutingProblemSolution runAndGetSolution(VehicleRoutingProblemSolution vrpSolution) {
        Collection<Job> ruinedJobs = this.ruin.ruin(vrpSolution.getRoutes());
        HashSet<Job> ruinedJobSet = new HashSet<Job>();
        ruinedJobSet.addAll(ruinedJobs);
        ruinedJobSet.addAll(vrpSolution.getUnassignedJobs());
        Collection<Job> unassignedJobs = this.insertion.insertJobs(vrpSolution.getRoutes(), ruinedJobSet);
        vrpSolution.getUnassignedJobs().clear();
        vrpSolution.getUnassignedJobs().addAll(unassignedJobs);
        return vrpSolution;
    }

    @Override
    public String getName() {
        return this.moduleName;
    }

    @Override
    public void addModuleListener(SearchStrategyModuleListener moduleListener) {
        if (moduleListener instanceof InsertionListener) {
            InsertionListener iListener = (InsertionListener)moduleListener;
            if (!this.insertion.getListeners().contains(iListener)) {
                this.insertion.addListener(iListener);
            }
        }
        if (moduleListener instanceof RuinListener) {
            RuinListener rListener = (RuinListener)moduleListener;
            if (!this.ruin.getListeners().contains(rListener)) {
                this.ruin.addListener(rListener);
            }
        }
    }

    public InsertionStrategy getInsertion() {
        return this.insertion;
    }

    public RuinStrategy getRuin() {
        return this.ruin;
    }
}

