/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionStartsListener;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.util.RandomNumberGeneration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CalculatesServiceInsertionWithTimeScheduling
implements JobInsertionCostsCalculator {
    private static Logger log = LoggerFactory.getLogger(CalculatesServiceInsertionWithTimeScheduling.class);
    private JobInsertionCostsCalculator jic;
    private List<Double> departureTimeKnowledge = new ArrayList<Double>();
    private Random random = RandomNumberGeneration.getRandom();

    public void setRandom(Random random) {
        this.random = random;
    }

    CalculatesServiceInsertionWithTimeScheduling(JobInsertionCostsCalculator jic, double t, double f) {
        this.jic = jic;
        log.debug("initialise " + this);
    }

    public String toString() {
        return "[name=" + this.getClass().toString() + "]";
    }

    @Override
    public InsertionData getInsertionData(VehicleRoute currentRoute, Job jobToInsert, Vehicle newVehicle, double newVehicleDepartureTime, Driver newDriver, double bestKnownScore) {
        double departureTime = newVehicleDepartureTime;
        if (currentRoute.isEmpty()) {
            if (!this.departureTimeKnowledge.isEmpty()) {
                departureTime = this.departureTimeKnowledge.get(this.random.nextInt(this.departureTimeKnowledge.size()));
            }
        } else if (!currentRoute.getVehicle().getId().equals(newVehicle.getId())) {
            departureTime = currentRoute.getDepartureTime();
        }
        InsertionData insertionData = this.jic.getInsertionData(currentRoute, jobToInsert, newVehicle, departureTime, newDriver, bestKnownScore);
        return insertionData;
    }

    public void setDepartureTimeKnowledge(List<Double> departureTimes) {
        this.departureTimeKnowledge = departureTimes;
    }

    public static class KnowledgeInjection
    implements InsertionStartsListener {
        private CalculatesServiceInsertionWithTimeScheduling c;

        public KnowledgeInjection(CalculatesServiceInsertionWithTimeScheduling c) {
            this.c = c;
        }

        @Override
        public void informInsertionStarts(Collection<VehicleRoute> vehicleRoutes, Collection<Job> unassignedJobs) {
            ArrayList<Double> knowledge = new ArrayList<Double>();
            if (vehicleRoutes.isEmpty()) {
                // empty if block
            }
            for (VehicleRoute route : vehicleRoutes) {
                knowledge.add(route.getDepartureTime());
            }
            this.c.setDepartureTimeKnowledge(knowledge);
        }
    }
}

