/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.Event;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.ScoredJob;
import com.graphhopper.jsprit.core.algorithm.recreate.Scorer;
import com.graphhopper.jsprit.core.algorithm.recreate.ScoringFunction;
import com.graphhopper.jsprit.core.algorithm.recreate.SwitchVehicle;
import com.graphhopper.jsprit.core.algorithm.recreate.VersionedInsertionData;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleFleetManager;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class InsertionDataUpdater {
    InsertionDataUpdater() {
    }

    static boolean update(boolean addAllAvailable, Set<String> initialVehicleIds, VehicleFleetManager fleetManager, JobInsertionCostsCalculator insertionCostsCalculator, TreeSet<VersionedInsertionData> insertionDataSet, int updateRound, Job unassignedJob, Collection<VehicleRoute> routes) {
        for (VehicleRoute route : routes) {
            ArrayList<Vehicle> relevantVehicles = new ArrayList<Vehicle>();
            if (!(route.getVehicle() instanceof VehicleImpl.NoVehicle)) {
                relevantVehicles.add(route.getVehicle());
                if (addAllAvailable && !initialVehicleIds.contains(route.getVehicle().getId())) {
                    relevantVehicles.addAll(fleetManager.getAvailableVehicles(route.getVehicle()));
                }
            } else {
                relevantVehicles.addAll(fleetManager.getAvailableVehicles());
            }
            for (Vehicle v : relevantVehicles) {
                double depTime;
                InsertionData iData = insertionCostsCalculator.getInsertionData(route, unassignedJob, v, depTime = v.getEarliestDeparture(), route.getDriver(), Double.MAX_VALUE);
                if (iData instanceof InsertionData.NoInsertionFound) continue;
                insertionDataSet.add(new VersionedInsertionData(iData, updateRound, route));
            }
        }
        return true;
    }

    static VehicleRoute findRoute(Collection<VehicleRoute> routes, Job job) {
        for (VehicleRoute r : routes) {
            if (r.getVehicle().getBreak() != job) continue;
            return r;
        }
        return null;
    }

    static Comparator<VersionedInsertionData> getComparator() {
        return new Comparator<VersionedInsertionData>(){

            @Override
            public int compare(VersionedInsertionData o1, VersionedInsertionData o2) {
                if (o1.getiData().getInsertionCost() < o2.getiData().getInsertionCost()) {
                    return -1;
                }
                return 1;
            }
        };
    }

    static ScoredJob getBest(boolean switchAllowed, Set<String> initialVehicleIds, VehicleFleetManager fleetManager, JobInsertionCostsCalculator insertionCostsCalculator, ScoringFunction scoringFunction, TreeSet<VersionedInsertionData>[] priorityQueues, Map<VehicleRoute, Integer> updates, List<Job> unassignedJobList, List<Job> badJobs) {
        ScoredJob bestScoredJob = null;
        for (Job j : unassignedJobList) {
            VehicleRoute emptyRoute;
            InsertionData iData;
            VehicleRoute bestRoute = null;
            InsertionData best = null;
            InsertionData secondBest = null;
            TreeSet<VersionedInsertionData> priorityQueue = priorityQueues[j.getIndex()];
            for (VersionedInsertionData versionedIData : priorityQueue) {
                if (bestRoute != null && versionedIData.getRoute() == bestRoute || versionedIData.getiData() instanceof InsertionData.NoInsertionFound || !(versionedIData.getRoute().getVehicle() instanceof VehicleImpl.NoVehicle) && versionedIData.getiData().getSelectedVehicle() != versionedIData.getRoute().getVehicle() && (!switchAllowed || initialVehicleIds.contains(versionedIData.getRoute().getVehicle().getId()))) continue;
                if (versionedIData.getiData().getSelectedVehicle() != versionedIData.getRoute().getVehicle() && fleetManager.isLocked(versionedIData.getiData().getSelectedVehicle())) {
                    Vehicle available = fleetManager.getAvailableVehicle(versionedIData.getiData().getSelectedVehicle().getVehicleTypeIdentifier());
                    if (available == null) continue;
                    InsertionData oldData = versionedIData.getiData();
                    InsertionData newData = new InsertionData(oldData.getInsertionCost(), oldData.getPickupInsertionIndex(), oldData.getDeliveryInsertionIndex(), available, oldData.getSelectedDriver());
                    newData.setVehicleDepartureTime(oldData.getVehicleDepartureTime());
                    for (Event e : oldData.getEvents()) {
                        if (e instanceof SwitchVehicle) {
                            newData.getEvents().add(new SwitchVehicle(versionedIData.getRoute(), available, oldData.getVehicleDepartureTime()));
                            continue;
                        }
                        newData.getEvents().add(e);
                    }
                    versionedIData = new VersionedInsertionData(newData, versionedIData.getVersion(), versionedIData.getRoute());
                }
                int currentDataVersion = updates.get(versionedIData.getRoute());
                if (versionedIData.getVersion() != currentDataVersion) continue;
                if (best == null) {
                    best = versionedIData.getiData();
                    bestRoute = versionedIData.getRoute();
                    continue;
                }
                secondBest = versionedIData.getiData();
                break;
            }
            if (!((iData = insertionCostsCalculator.getInsertionData(emptyRoute = VehicleRoute.emptyRoute(), j, null, -1.0, null, Double.MAX_VALUE)) instanceof InsertionData.NoInsertionFound)) {
                if (best == null) {
                    best = iData;
                    bestRoute = emptyRoute;
                } else if (iData.getInsertionCost() < best.getInsertionCost()) {
                    secondBest = best;
                    best = iData;
                    bestRoute = emptyRoute;
                } else if (secondBest == null || iData.getInsertionCost() < secondBest.getInsertionCost()) {
                    secondBest = iData;
                }
            }
            if (best == null) {
                badJobs.add(j);
                continue;
            }
            double score = InsertionDataUpdater.score(j, best, secondBest, scoringFunction);
            ScoredJob scoredJob = bestRoute == emptyRoute ? new ScoredJob(j, score, best, bestRoute, true) : new ScoredJob(j, score, best, bestRoute, false);
            if (bestScoredJob == null) {
                bestScoredJob = scoredJob;
                continue;
            }
            if (!(scoredJob.getScore() > bestScoredJob.getScore())) continue;
            bestScoredJob = scoredJob;
        }
        return bestScoredJob;
    }

    static double score(Job unassignedJob, InsertionData best, InsertionData secondBest, ScoringFunction scoringFunction) {
        return Scorer.score(unassignedJob, best, secondBest, scoringFunction);
    }
}

