/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.AbstractInsertionStrategy;
import com.graphhopper.jsprit.core.algorithm.recreate.DefaultScorer;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.RegretInsertion;
import com.graphhopper.jsprit.core.algorithm.recreate.RegretInsertionConcurrentFast;
import com.graphhopper.jsprit.core.algorithm.recreate.ScoredJob;
import com.graphhopper.jsprit.core.algorithm.recreate.ScoringFunction;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Break;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegretInsertionConcurrent
extends AbstractInsertionStrategy {
    private static Logger logger = LoggerFactory.getLogger(RegretInsertionConcurrentFast.class);
    private ScoringFunction scoringFunction;
    private final JobInsertionCostsCalculator insertionCostsCalculator;
    private final ExecutorCompletionService<ScoredJob> completionService;

    public void setScoringFunction(ScoringFunction scoringFunction) {
        this.scoringFunction = scoringFunction;
    }

    public RegretInsertionConcurrent(JobInsertionCostsCalculator jobInsertionCalculator, VehicleRoutingProblem vehicleRoutingProblem, ExecutorService executorService) {
        super(vehicleRoutingProblem);
        this.scoringFunction = new DefaultScorer(vehicleRoutingProblem);
        this.insertionCostsCalculator = jobInsertionCalculator;
        this.vrp = vehicleRoutingProblem;
        this.completionService = new ExecutorCompletionService(executorService);
        logger.debug("initialise " + this);
    }

    public String toString() {
        return "[name=regretInsertion][additionalScorer=" + this.scoringFunction + "]";
    }

    @Override
    public Collection<Job> insertUnassignedJobs(Collection<VehicleRoute> routes, Collection<Job> unassignedJobs) {
        ArrayList<Job> badJobs = new ArrayList<Job>(unassignedJobs.size());
        Iterator<Job> jobIterator = unassignedJobs.iterator();
        while (jobIterator.hasNext()) {
            Job job = jobIterator.next();
            if (!(job instanceof Break)) continue;
            VehicleRoute route = this.findRoute(routes, job);
            if (route == null) {
                badJobs.add(job);
            } else {
                InsertionData iData = this.insertionCostsCalculator.getInsertionData(route, job, NO_NEW_VEHICLE_YET, -12345.12345, NO_NEW_DRIVER_YET, Double.MAX_VALUE);
                if (iData instanceof InsertionData.NoInsertionFound) {
                    badJobs.add(job);
                } else {
                    this.insertJob(job, iData, route);
                }
            }
            jobIterator.remove();
        }
        ArrayList<Job> jobs = new ArrayList<Job>(unassignedJobs);
        while (!jobs.isEmpty()) {
            ArrayList<Job> unassignedJobList = new ArrayList<Job>(jobs);
            ArrayList<Job> badJobList = new ArrayList<Job>();
            ScoredJob bestScoredJob = this.nextJob(routes, unassignedJobList, badJobList);
            if (bestScoredJob != null) {
                if (bestScoredJob.isNewRoute()) {
                    routes.add(bestScoredJob.getRoute());
                }
                this.insertJob(bestScoredJob.getJob(), bestScoredJob.getInsertionData(), bestScoredJob.getRoute());
                jobs.remove(bestScoredJob.getJob());
            }
            for (Job j : badJobList) {
                jobs.remove(j);
                badJobs.add(j);
            }
        }
        return badJobs;
    }

    private ScoredJob nextJob(final Collection<VehicleRoute> routes, List<Job> unassignedJobList, List<Job> badJobList) {
        ScoredJob bestScoredJob = null;
        for (final Job unassignedJob : unassignedJobList) {
            this.completionService.submit(new Callable<ScoredJob>(){

                @Override
                public ScoredJob call() throws Exception {
                    return RegretInsertion.getScoredJob(routes, unassignedJob, RegretInsertionConcurrent.this.insertionCostsCalculator, RegretInsertionConcurrent.this.scoringFunction);
                }
            });
        }
        try {
            for (int i = 0; i < unassignedJobList.size(); ++i) {
                Future<ScoredJob> fsj = this.completionService.take();
                ScoredJob sJob = fsj.get();
                if (sJob instanceof ScoredJob.BadJob) {
                    badJobList.add(sJob.getJob());
                    continue;
                }
                if (bestScoredJob == null) {
                    bestScoredJob = sJob;
                    continue;
                }
                if (sJob.getScore() > bestScoredJob.getScore()) {
                    bestScoredJob = sJob;
                    continue;
                }
                if (sJob.getScore() != bestScoredJob.getScore() || sJob.getJob().getId().compareTo(bestScoredJob.getJob().getId()) > 0) continue;
                bestScoredJob = sJob;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return bestScoredJob;
    }

    private VehicleRoute findRoute(Collection<VehicleRoute> routes, Job job) {
        for (VehicleRoute r : routes) {
            if (r.getVehicle().getBreak() != job) continue;
            return r;
        }
        return null;
    }
}

