/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.ruin.listener;

import com.graphhopper.jsprit.core.algorithm.ruin.listener.RuinListener;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class RuinListeners {
    private Collection<RuinListener> ruinListeners = new ArrayList<RuinListener>();

    public void ruinStarts(Collection<VehicleRoute> routes) {
        for (RuinListener l : this.ruinListeners) {
            l.ruinStarts(routes);
        }
    }

    public void ruinEnds(Collection<VehicleRoute> routes, Collection<Job> unassignedJobs) {
        for (RuinListener l : this.ruinListeners) {
            l.ruinEnds(routes, unassignedJobs);
        }
    }

    public void removed(Job job, VehicleRoute fromRoute) {
        for (RuinListener l : this.ruinListeners) {
            l.removed(job, fromRoute);
        }
    }

    public void addListener(RuinListener ruinListener) {
        this.ruinListeners.add(ruinListener);
    }

    public void removeListener(RuinListener ruinListener) {
        this.ruinListeners.remove(ruinListener);
    }

    public Collection<RuinListener> getListeners() {
        return Collections.unmodifiableCollection(this.ruinListeners);
    }
}

