/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.state;

import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.algorithm.state.StateUpdater;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.BreakActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ReverseActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;

public class UpdateFutureWaitingTimes
implements ReverseActivityVisitor,
StateUpdater {
    private StateManager states;
    private VehicleRoute route;
    private VehicleRoutingTransportCosts transportCosts;
    private double futureWaiting;

    public UpdateFutureWaitingTimes(StateManager states, VehicleRoutingTransportCosts tpCosts) {
        this.states = states;
        this.transportCosts = tpCosts;
    }

    @Override
    public void begin(VehicleRoute route) {
        this.route = route;
        this.futureWaiting = 0.0;
    }

    @Override
    public void visit(TourActivity activity) {
        this.states.putInternalTypedActivityState(activity, this.route.getVehicle(), InternalStates.FUTURE_WAITING, this.futureWaiting);
        if (!(activity instanceof BreakActivity)) {
            this.futureWaiting += Math.max(activity.getTheoreticalEarliestOperationStartTime() - activity.getArrTime(), 0.0);
        }
    }

    @Override
    public void finish() {
    }
}

