/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.state;

import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.algorithm.state.StateUpdater;
import com.graphhopper.jsprit.core.problem.cost.ForwardTransportCost;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingActivityCosts;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.util.ActivityTimeTracker;

public class UpdateVariableCosts
implements ActivityVisitor,
StateUpdater {
    private VehicleRoutingActivityCosts activityCost;
    private ForwardTransportCost transportCost;
    private StateManager states;
    private double totalOperationCost = 0.0;
    private VehicleRoute vehicleRoute = null;
    private TourActivity prevAct = null;
    private double startTimeAtPrevAct = 0.0;
    private ActivityTimeTracker timeTracker;

    public UpdateVariableCosts(VehicleRoutingActivityCosts activityCost, VehicleRoutingTransportCosts transportCost, StateManager states) {
        this.activityCost = activityCost;
        this.transportCost = transportCost;
        this.states = states;
        this.timeTracker = new ActivityTimeTracker(transportCost, activityCost);
    }

    public UpdateVariableCosts(VehicleRoutingActivityCosts activityCosts, VehicleRoutingTransportCosts transportCosts, StateManager stateManager, ActivityTimeTracker.ActivityPolicy activityPolicy) {
        this.activityCost = activityCosts;
        this.transportCost = transportCosts;
        this.states = stateManager;
        this.timeTracker = new ActivityTimeTracker(transportCosts, activityPolicy, activityCosts);
    }

    @Override
    public void begin(VehicleRoute route) {
        this.vehicleRoute = route;
        this.timeTracker.begin(route);
        this.prevAct = route.getStart();
        this.startTimeAtPrevAct = this.timeTracker.getActEndTime();
    }

    @Override
    public void visit(TourActivity act) {
        this.timeTracker.visit(act);
        double transportCost = this.transportCost.getTransportCost(this.prevAct.getLocation(), act.getLocation(), this.startTimeAtPrevAct, this.vehicleRoute.getDriver(), this.vehicleRoute.getVehicle());
        double actCost = this.activityCost.getActivityCost(act, this.timeTracker.getActArrTime(), this.vehicleRoute.getDriver(), this.vehicleRoute.getVehicle());
        this.totalOperationCost += transportCost;
        this.totalOperationCost += actCost;
        this.states.putInternalTypedActivityState(act, InternalStates.COSTS, this.totalOperationCost);
        this.prevAct = act;
        this.startTimeAtPrevAct = this.timeTracker.getActEndTime();
    }

    @Override
    public void finish() {
        this.timeTracker.finish();
        double transportCost = this.transportCost.getTransportCost(this.prevAct.getLocation(), this.vehicleRoute.getEnd().getLocation(), this.startTimeAtPrevAct, this.vehicleRoute.getDriver(), this.vehicleRoute.getVehicle());
        double actCost = this.activityCost.getActivityCost(this.vehicleRoute.getEnd(), this.timeTracker.getActEndTime(), this.vehicleRoute.getDriver(), this.vehicleRoute.getVehicle());
        this.totalOperationCost += transportCost;
        this.totalOperationCost += actCost;
        this.states.putTypedInternalRouteState(this.vehicleRoute, InternalStates.COSTS, this.totalOperationCost);
        this.startTimeAtPrevAct = 0.0;
        this.prevAct = null;
        this.vehicleRoute = null;
        this.totalOperationCost = 0.0;
    }
}

