/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.termination;

import com.graphhopper.jsprit.core.algorithm.SearchStrategy;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.listener.AlgorithmStartsListener;
import com.graphhopper.jsprit.core.algorithm.listener.IterationEndsListener;
import com.graphhopper.jsprit.core.algorithm.listener.IterationStartsListener;
import com.graphhopper.jsprit.core.algorithm.termination.PrematureAlgorithmTermination;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.util.Solutions;
import java.util.Collection;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariationCoefficientTermination
implements PrematureAlgorithmTermination,
IterationStartsListener,
AlgorithmStartsListener,
IterationEndsListener {
    private static final Logger logger = LoggerFactory.getLogger(VariationCoefficientTermination.class);
    private final int noIterations;
    private final double variationCoefficientThreshold;
    private int currentIteration;
    private double[] solutionValues;
    private VehicleRoutingProblemSolution lastAccepted = null;

    public VariationCoefficientTermination(int noIterations, double variationCoefficientThreshold) {
        this.noIterations = noIterations;
        this.variationCoefficientThreshold = variationCoefficientThreshold;
        this.solutionValues = new double[noIterations];
        logger.debug("initialise {}", (Object)this);
    }

    public String toString() {
        return "[name=VariationCoefficientBreaker][variationCoefficientThreshold=" + this.variationCoefficientThreshold + "][iterations=" + this.noIterations + "]";
    }

    @Override
    public boolean isPrematureBreak(SearchStrategy.DiscoveredSolution discoveredSolution) {
        double mean;
        double stdDev;
        double variationCoefficient;
        if (discoveredSolution.isAccepted()) {
            this.lastAccepted = discoveredSolution.getSolution();
            this.solutionValues[this.currentIteration] = discoveredSolution.getSolution().getCost();
        } else {
            this.solutionValues[this.currentIteration] = this.lastAccepted != null ? this.lastAccepted.getCost() : 2.147483647E9;
        }
        return this.currentIteration == this.noIterations - 1 && (variationCoefficient = (stdDev = new StandardDeviation(true).evaluate(this.solutionValues, mean = StatUtils.mean((double[])this.solutionValues))) / mean) < this.variationCoefficientThreshold;
    }

    private void reset() {
        this.currentIteration = 0;
    }

    @Override
    public void informAlgorithmStarts(VehicleRoutingProblem problem, VehicleRoutingAlgorithm algorithm, Collection<VehicleRoutingProblemSolution> solutions) {
        this.reset();
    }

    @Override
    public void informIterationEnds(int i, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        if (this.currentIteration == this.noIterations - 1) {
            this.reset();
        } else {
            ++this.currentIteration;
        }
    }

    @Override
    public void informIterationStarts(int i, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        if (this.lastAccepted == null) {
            this.lastAccepted = Solutions.bestOf(solutions);
        }
    }
}

