/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Skills {
    private Set<String> skills = new HashSet<String>();

    private Skills(Builder builder) {
        this.skills.addAll(builder.skills);
    }

    public Set<String> values() {
        return Collections.unmodifiableSet(this.skills);
    }

    public String toString() {
        String s = "[";
        boolean first = true;
        for (String skill : this.values()) {
            if (first) {
                s = s + skill;
                first = false;
                continue;
            }
            s = s + ", " + skill;
        }
        s = s + "]";
        return s;
    }

    public boolean containsSkill(String skill) {
        return this.skills.contains(skill.toLowerCase());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Skills skills1 = (Skills)o;
        return !(this.skills != null ? !this.skills.equals(skills1.skills) : skills1.skills != null);
    }

    public int hashCode() {
        return this.skills != null ? this.skills.hashCode() : 0;
    }

    public static class Builder {
        private Set<String> skills = new HashSet<String>();

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder addSkill(String skill) {
            this.skills.add(skill.trim().toLowerCase());
            return this;
        }

        public Builder addAllSkills(Collection<String> skills) {
            for (String skill : skills) {
                this.addSkill(skill);
            }
            return this;
        }

        public Skills build() {
            return new Skills(this);
        }
    }
}

