/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.constraint;

import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.problem.Skills;
import com.graphhopper.jsprit.core.problem.constraint.HardRouteConstraint;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;

public class HardSkillConstraint
implements HardRouteConstraint {
    private static final Skills defaultSkills = Skills.Builder.newInstance().build();
    private RouteAndActivityStateGetter states;

    public HardSkillConstraint(RouteAndActivityStateGetter states) {
        this.states = states;
    }

    @Override
    public boolean fulfilled(JobInsertionContext insertionContext) {
        for (String skill : insertionContext.getJob().getRequiredSkills().values()) {
            if (insertionContext.getNewVehicle().getSkills().containsSkill(skill)) continue;
            return false;
        }
        Skills requiredSkillsForRoute = this.states.getRouteState(insertionContext.getRoute(), InternalStates.SKILLS, Skills.class);
        if (requiredSkillsForRoute == null) {
            requiredSkillsForRoute = defaultSkills;
        }
        for (String skill : requiredSkillsForRoute.values()) {
            if (insertionContext.getNewVehicle().getSkills().containsSkill(skill)) continue;
            return false;
        }
        return true;
    }
}

