/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.job;

import com.graphhopper.jsprit.core.problem.AbstractJob;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.Skills;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindow;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindows;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TimeWindowsImpl;
import com.graphhopper.jsprit.core.util.Coordinate;
import java.util.Collection;

public class Service
extends AbstractJob {
    private final String id;
    private final String type;
    private final double serviceTime;
    private final TimeWindow timeWindow;
    private final Capacity size;
    private final Skills skills;
    private final String name;
    private final Location location;
    private final TimeWindows timeWindowManager;
    private final int priority;

    Service(Builder builder) {
        this.id = builder.id;
        this.serviceTime = builder.serviceTime;
        this.timeWindow = builder.timeWindow;
        this.type = builder.type;
        this.size = builder.capacity;
        this.skills = builder.skills;
        this.name = builder.name;
        this.location = builder.location;
        this.timeWindowManager = builder.timeWindows;
        this.priority = builder.priority;
    }

    public Collection<TimeWindow> getTimeWindows() {
        return this.timeWindowManager.getTimeWindows();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Location getLocation() {
        return this.location;
    }

    public double getServiceDuration() {
        return this.serviceTime;
    }

    public TimeWindow getTimeWindow() {
        return this.timeWindowManager.getTimeWindows().iterator().next();
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return "[id=" + this.id + "][name=" + this.name + "][type=" + this.type + "][location=" + this.location + "][capacity=" + this.size + "][serviceTime=" + this.serviceTime + "][timeWindow=" + this.timeWindow + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Service other = (Service)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public Capacity getSize() {
        return this.size;
    }

    @Override
    public Skills getRequiredSkills() {
        return this.skills;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public static class Builder<T extends Service> {
        private String id;
        protected String locationId;
        private String type = "service";
        protected Coordinate coord;
        protected double serviceTime;
        protected TimeWindow timeWindow = TimeWindow.newInstance(0.0, Double.MAX_VALUE);
        protected Capacity.Builder capacityBuilder = Capacity.Builder.newInstance();
        protected Capacity capacity;
        protected Skills.Builder skillBuilder = Skills.Builder.newInstance();
        protected Skills skills;
        private String name = "no-name";
        protected Location location;
        protected TimeWindowsImpl timeWindows;
        private boolean twAdded = false;
        private int priority = 2;

        public static Builder newInstance(String id) {
            return new Builder(id);
        }

        Builder(String id) {
            this.id = id;
            this.timeWindows = new TimeWindowsImpl();
            this.timeWindows.add(this.timeWindow);
        }

        protected Builder<T> setType(String name) {
            this.type = name;
            return this;
        }

        public Builder<T> setLocation(Location location) {
            this.location = location;
            return this;
        }

        public Builder<T> setServiceTime(double serviceTime) {
            if (serviceTime < 0.0) {
                throw new IllegalArgumentException("serviceTime must be greater than or equal to zero");
            }
            this.serviceTime = serviceTime;
            return this;
        }

        public Builder<T> addSizeDimension(int dimensionIndex, int dimensionValue) {
            if (dimensionValue < 0) {
                throw new IllegalArgumentException("capacity value cannot be negative");
            }
            this.capacityBuilder.addDimension(dimensionIndex, dimensionValue);
            return this;
        }

        public Builder<T> setTimeWindow(TimeWindow tw) {
            if (tw == null) {
                throw new IllegalArgumentException("time-window arg must not be null");
            }
            this.timeWindow = tw;
            this.timeWindows = new TimeWindowsImpl();
            this.timeWindows.add(tw);
            return this;
        }

        public Builder<T> addTimeWindow(TimeWindow timeWindow) {
            if (timeWindow == null) {
                throw new IllegalArgumentException("time-window arg must not be null");
            }
            if (!this.twAdded) {
                this.timeWindows = new TimeWindowsImpl();
                this.twAdded = true;
            }
            this.timeWindows.add(timeWindow);
            return this;
        }

        public Builder<T> addTimeWindow(double earliest, double latest) {
            return this.addTimeWindow(TimeWindow.newInstance(earliest, latest));
        }

        public T build() {
            if (this.location == null) {
                throw new IllegalArgumentException("location is missing");
            }
            this.setType("service");
            this.capacity = this.capacityBuilder.build();
            this.skills = this.skillBuilder.build();
            return (T)new Service(this);
        }

        public Builder<T> addRequiredSkill(String skill) {
            this.skillBuilder.addSkill(skill);
            return this;
        }

        public Builder<T> setName(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> addAllRequiredSkills(Skills skills) {
            for (String s : skills.values()) {
                this.skillBuilder.addSkill(s);
            }
            return this;
        }

        public Builder<T> addAllSizeDimensions(Capacity size) {
            for (int i = 0; i < size.getNuOfDimensions(); ++i) {
                this.capacityBuilder.addDimension(i, size.get(i));
            }
            return this;
        }

        public Builder<T> setPriority(int priority) {
            if (priority < 1 || priority > 3) {
                throw new IllegalArgumentException("incorrect priority. only 1 = high, 2 = medium and 3 = low is allowed");
            }
            this.priority = priority;
            return this;
        }
    }
}

