/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.solution.route.activity;

public class TimeWindow {
    private final double start;
    private final double end;

    public static TimeWindow newInstance(double start, double end) {
        return new TimeWindow(start, end);
    }

    public TimeWindow(double start, double end) {
        if (start < 0.0 || end < 0.0) {
            throw new IllegalArgumentException("neither time window start nor end must be < 0.0: [start=" + start + "][end=" + end + "]");
        }
        if (end < start) {
            throw new IllegalArgumentException("time window end cannot be smaller than its start: [start=" + start + "][end=" + end + "]");
        }
        this.start = start;
        this.end = end;
    }

    public double getStart() {
        return this.start;
    }

    public double getEnd() {
        return this.end;
    }

    public String toString() {
        return "[start=" + this.start + "][end=" + this.end + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.end);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.start);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeWindow other = (TimeWindow)obj;
        if (Double.doubleToLongBits(this.end) != Double.doubleToLongBits(other.end)) {
            return false;
        }
        return Double.doubleToLongBits(this.start) == Double.doubleToLongBits(other.start);
    }
}

