/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.vehicle;

import com.graphhopper.jsprit.core.problem.AbstractVehicle;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.Skills;
import com.graphhopper.jsprit.core.problem.job.Break;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleType;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleImpl
extends AbstractVehicle {
    private final String id;
    private final VehicleType type;
    private final double earliestDeparture;
    private final double latestArrival;
    private final boolean returnToDepot;
    private final Skills skills;
    private final Location endLocation;
    private final Location startLocation;
    private final Break aBreak;

    public static NoVehicle createNoVehicle() {
        return new NoVehicle();
    }

    private VehicleImpl(Builder builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.earliestDeparture = builder.earliestStart;
        this.latestArrival = builder.latestArrival;
        this.returnToDepot = builder.returnToDepot;
        this.skills = builder.skills;
        this.endLocation = builder.endLocation;
        this.startLocation = builder.startLocation;
        this.aBreak = builder.aBreak;
        this.setVehicleIdentifier(new VehicleTypeKey(this.type.getTypeId(), this.startLocation.getId(), this.endLocation.getId(), this.earliestDeparture, this.latestArrival, this.skills, this.returnToDepot));
    }

    public String toString() {
        return "[id=" + this.id + "]" + "[type=" + this.type + "]" + "[startLocation=" + this.startLocation + "]" + "[endLocation=" + this.endLocation + "]" + "[isReturnToDepot=" + this.isReturnToDepot() + "]" + "[skills=" + this.skills + "]";
    }

    @Override
    public double getEarliestDeparture() {
        return this.earliestDeparture;
    }

    @Override
    public double getLatestArrival() {
        return this.latestArrival;
    }

    @Override
    public VehicleType getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isReturnToDepot() {
        return this.returnToDepot;
    }

    @Override
    public Location getStartLocation() {
        return this.startLocation;
    }

    @Override
    public Location getEndLocation() {
        return this.endLocation;
    }

    @Override
    public Skills getSkills() {
        return this.skills;
    }

    @Override
    public Break getBreak() {
        return this.aBreak;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VehicleImpl other = (VehicleImpl)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public static class Builder {
        static final Logger log = LoggerFactory.getLogger((String)Builder.class.getName());
        private String id;
        private double earliestStart = 0.0;
        private double latestArrival = Double.MAX_VALUE;
        private boolean returnToDepot = true;
        private VehicleType type = VehicleTypeImpl.Builder.newInstance("default").build();
        private Skills.Builder skillBuilder = Skills.Builder.newInstance();
        private Skills skills;
        private Location startLocation;
        private Location endLocation;
        private Break aBreak;

        private Builder(String id) {
            this.id = id;
        }

        public Builder setType(VehicleType type) {
            if (type == null) {
                throw new IllegalArgumentException("type cannot be null.");
            }
            this.type = type;
            return this;
        }

        public Builder setReturnToDepot(boolean returnToDepot) {
            this.returnToDepot = returnToDepot;
            return this;
        }

        public Builder setStartLocation(Location startLocation) {
            this.startLocation = startLocation;
            return this;
        }

        public Builder setEndLocation(Location endLocation) {
            this.endLocation = endLocation;
            return this;
        }

        public Builder setEarliestStart(double earliest_startTime) {
            if (earliest_startTime < 0.0) {
                throw new IllegalArgumentException("earliest start of vehicle " + this.id + " must not be negative");
            }
            this.earliestStart = earliest_startTime;
            return this;
        }

        public Builder setLatestArrival(double latest_arrTime) {
            if (latest_arrTime < 0.0) {
                throw new IllegalArgumentException("latest arrival time of vehicle " + this.id + " must not be negative");
            }
            this.latestArrival = latest_arrTime;
            return this;
        }

        public Builder addSkill(String skill) {
            this.skillBuilder.addSkill(skill);
            return this;
        }

        public VehicleImpl build() {
            if (this.latestArrival < this.earliestStart) {
                throw new IllegalArgumentException("latest arrival of vehicle " + this.id + " must not be smaller than its start time");
            }
            if (this.startLocation != null && this.endLocation != null && !this.startLocation.getId().equals(this.endLocation.getId()) && !this.returnToDepot) {
                throw new IllegalArgumentException("this must not be. you specified both endLocationId and open-routes. this is contradictory. <br>if you set endLocation, returnToDepot must be true. if returnToDepot is false, endLocationCoord must not be specified.");
            }
            if (this.startLocation != null && this.endLocation == null) {
                this.endLocation = this.startLocation;
            }
            if (this.startLocation == null && this.endLocation == null) {
                throw new IllegalArgumentException("vehicle requires startLocation. but neither locationId nor locationCoord nor startLocationId nor startLocationCoord has been set");
            }
            this.skills = this.skillBuilder.build();
            return new VehicleImpl(this);
        }

        public static Builder newInstance(String vehicleId) {
            return new Builder(vehicleId);
        }

        public Builder addSkills(Skills skills) {
            this.skillBuilder.addAllSkills(skills.values());
            return this;
        }

        public Builder setBreak(Break aBreak) {
            this.aBreak = aBreak;
            return this;
        }
    }

    public static class NoVehicle
    extends AbstractVehicle {
        private String id = "noVehicle";
        private VehicleType type = VehicleTypeImpl.Builder.newInstance("noType").build();

        @Override
        public double getEarliestDeparture() {
            return 0.0;
        }

        @Override
        public double getLatestArrival() {
            return 0.0;
        }

        @Override
        public VehicleType getType() {
            return this.type;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean isReturnToDepot() {
            return false;
        }

        @Override
        public Location getStartLocation() {
            return null;
        }

        @Override
        public Location getEndLocation() {
            return null;
        }

        @Override
        public Skills getSkills() {
            return null;
        }

        @Override
        public Break getBreak() {
            return null;
        }
    }
}

