/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.util;

import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.cost.AbstractForwardVehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.cost.TransportDistance;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.util.Coordinate;
import com.graphhopper.jsprit.core.util.EuclideanDistanceCalculator;
import com.graphhopper.jsprit.core.util.Locations;

public class CrowFlyCosts
extends AbstractForwardVehicleRoutingTransportCosts
implements TransportDistance {
    public int speed = 1;
    public double detourFactor = 1.0;
    private Locations locations;

    public CrowFlyCosts(Locations locations) {
        this.locations = locations;
    }

    public String toString() {
        return "[name=crowFlyCosts]";
    }

    @Override
    public double getTransportCost(Location from, Location to, double time, Driver driver, Vehicle vehicle) {
        double distance;
        try {
            distance = this.calculateDistance(from, to);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("cannot calculate euclidean distance. coordinates are missing. either add coordinates or use another transport-cost-calculator.");
        }
        double costs = distance;
        if (vehicle != null && vehicle.getType() != null) {
            costs = distance * vehicle.getType().getVehicleCostParams().perDistanceUnit;
        }
        return costs;
    }

    private double calculateDistance(Location fromLocation, Location toLocation) {
        Coordinate from = null;
        Coordinate to = null;
        if (fromLocation.getCoordinate() != null & toLocation.getCoordinate() != null) {
            from = fromLocation.getCoordinate();
            to = toLocation.getCoordinate();
        } else if (this.locations != null) {
            from = this.locations.getCoord(fromLocation.getId());
            to = this.locations.getCoord(toLocation.getId());
        }
        if (from == null || to == null) {
            throw new NullPointerException();
        }
        return this.calculateDistance(from, to);
    }

    private double calculateDistance(Coordinate from, Coordinate to) {
        return EuclideanDistanceCalculator.calculateDistance(from, to) * this.detourFactor;
    }

    @Override
    public double getTransportTime(Location from, Location to, double time, Driver driver, Vehicle vehicle) {
        double distance;
        try {
            distance = this.calculateDistance(from, to);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("cannot calculate euclidean distance. coordinates are missing. either add coordinates or use another transport-cost-calculator.");
        }
        return distance / (double)this.speed;
    }

    @Override
    public double getDistance(Location from, Location to, double departureTime, Vehicle vehicle) {
        return this.calculateDistance(from, to);
    }
}

