/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.util;

import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.cost.AbstractForwardVehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.cost.TransportDistance;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;

public class FastVehicleRoutingTransportCostsMatrix
extends AbstractForwardVehicleRoutingTransportCosts
implements TransportDistance {
    private final boolean isSymmetric;
    private final double[][][] matrix;

    private FastVehicleRoutingTransportCostsMatrix(Builder builder) {
        this.isSymmetric = builder.isSymmetric;
        this.matrix = builder.matrix;
    }

    public double[][][] getMatrix() {
        return this.matrix;
    }

    @Override
    public double getTransportTime(Location from, Location to, double departureTime, Driver driver, Vehicle vehicle) {
        if (from.getIndex() < 0 || to.getIndex() < 0) {
            throw new IllegalArgumentException("index of from " + from + " to " + to + " < 0 ");
        }
        int timeIndex = 1;
        return this.get(from.getIndex(), to.getIndex(), timeIndex);
    }

    private double get(int from, int to, int indicatorIndex) {
        double value = this.isSymmetric ? (from < to ? this.matrix[from][to][indicatorIndex] : this.matrix[to][from][indicatorIndex]) : this.matrix[from][to][indicatorIndex];
        return value;
    }

    public double getDistance(int fromIndex, int toIndex) {
        int distanceIndex = 0;
        return this.get(fromIndex, toIndex, distanceIndex);
    }

    @Override
    public double getDistance(Location from, Location to, double departureTime, Vehicle vehicle) {
        return this.getDistance(from.getIndex(), to.getIndex());
    }

    @Override
    public double getTransportCost(Location from, Location to, double departureTime, Driver driver, Vehicle vehicle) {
        if (from.getIndex() < 0 || to.getIndex() < 0) {
            throw new IllegalArgumentException("index of from " + from + " to " + to + " < 0 ");
        }
        if (vehicle == null) {
            return this.getDistance(from.getIndex(), to.getIndex());
        }
        VehicleTypeImpl.VehicleCostParams costParams = vehicle.getType().getVehicleCostParams();
        return costParams.perDistanceUnit * this.getDistance(from.getIndex(), to.getIndex()) + costParams.perTransportTimeUnit * this.getTransportTime(from, to, departureTime, driver, vehicle);
    }

    public static class Builder {
        private boolean isSymmetric;
        private double[][][] matrix;

        public static Builder newInstance(int noLocations, boolean isSymmetric) {
            return new Builder(noLocations, isSymmetric);
        }

        private Builder(int noLocations, boolean isSymmetric) {
            this.isSymmetric = isSymmetric;
            this.matrix = new double[noLocations][noLocations][2];
        }

        public Builder addTransportDistance(int fromIndex, int toIndex, double distance) {
            this.add(fromIndex, toIndex, 0, distance);
            return this;
        }

        private void add(int fromIndex, int toIndex, int indicatorIndex, double distance) {
            if (this.isSymmetric) {
                if (fromIndex < toIndex) {
                    this.matrix[fromIndex][toIndex][indicatorIndex] = distance;
                } else {
                    this.matrix[toIndex][fromIndex][indicatorIndex] = distance;
                }
            } else {
                this.matrix[fromIndex][toIndex][indicatorIndex] = distance;
            }
        }

        public Builder addTransportTime(int fromIndex, int toIndex, double time) {
            this.add(fromIndex, toIndex, 1, time);
            return this;
        }

        public FastVehicleRoutingTransportCostsMatrix build() {
            return new FastVehicleRoutingTransportCostsMatrix(this);
        }
    }
}

