/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.util;

import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.cost.AbstractForwardVehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleTypeImpl;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleRoutingTransportCostsMatrix
extends AbstractForwardVehicleRoutingTransportCosts {
    private Map<RelationKey, Double> distances = new HashMap<RelationKey, Double>();
    private Map<RelationKey, Double> times = new HashMap<RelationKey, Double>();
    private boolean isSymmetric;
    private boolean timesSet;
    private boolean distancesSet;

    private VehicleRoutingTransportCostsMatrix(Builder builder) {
        this.isSymmetric = builder.isSymmetric;
        this.distances.putAll(builder.distances);
        this.times.putAll(builder.times);
        this.timesSet = builder.timesSet;
        this.distancesSet = builder.distancesSet;
    }

    @Override
    public double getTransportTime(Location from, Location to, double departureTime, Driver driver, Vehicle vehicle) {
        return this.getTime(from.getId(), to.getId());
    }

    private double getTime(String fromId, String toId) {
        if (fromId.equals(toId)) {
            return 0.0;
        }
        if (!this.timesSet) {
            return 0.0;
        }
        RelationKey key = RelationKey.newKey(fromId, toId);
        if (!this.isSymmetric) {
            if (this.times.containsKey(key)) {
                return this.times.get(key);
            }
            throw new IllegalStateException("time value for relation from " + fromId + " to " + toId + " does not exist");
        }
        Double time = this.times.get(key);
        if (time == null) {
            time = this.times.get(RelationKey.newKey(toId, fromId));
        }
        if (time != null) {
            return time;
        }
        throw new IllegalStateException("time value for relation from " + fromId + " to " + toId + " does not exist");
    }

    public double getDistance(String fromId, String toId) {
        if (fromId.equals(toId)) {
            return 0.0;
        }
        if (!this.distancesSet) {
            return 0.0;
        }
        RelationKey key = RelationKey.newKey(fromId, toId);
        if (!this.isSymmetric) {
            if (this.distances.containsKey(key)) {
                return this.distances.get(key);
            }
            throw new IllegalStateException("distance value for relation from " + fromId + " to " + toId + " does not exist");
        }
        Double time = this.distances.get(key);
        if (time == null) {
            time = this.distances.get(RelationKey.newKey(toId, fromId));
        }
        if (time != null) {
            return time;
        }
        throw new IllegalStateException("distance value for relation from " + fromId + " to " + toId + " does not exist");
    }

    @Override
    public double getTransportCost(Location from, Location to, double departureTime, Driver driver, Vehicle vehicle) {
        if (vehicle == null) {
            return this.getDistance(from.getId(), to.getId());
        }
        VehicleTypeImpl.VehicleCostParams costParams = vehicle.getType().getVehicleCostParams();
        return costParams.perDistanceUnit * this.getDistance(from.getId(), to.getId()) + costParams.perTransportTimeUnit * this.getTime(from.getId(), to.getId());
    }

    public static class Builder {
        private static Logger log = LoggerFactory.getLogger(Builder.class);
        private boolean isSymmetric;
        private Map<RelationKey, Double> distances = new HashMap<RelationKey, Double>();
        private Map<RelationKey, Double> times = new HashMap<RelationKey, Double>();
        private boolean distancesSet = false;
        private boolean timesSet = false;

        public static Builder newInstance(boolean isSymmetric) {
            return new Builder(isSymmetric);
        }

        private Builder(boolean isSymmetric) {
            this.isSymmetric = isSymmetric;
        }

        public Builder addTransportDistance(String from, String to, double distance) {
            RelationKey revKey;
            RelationKey key = RelationKey.newKey(from, to);
            if (!this.distancesSet) {
                this.distancesSet = true;
            }
            if (this.distances.containsKey(key)) {
                log.warn("distance from " + from + " to " + to + " already exists. This overrides distance.");
            }
            this.distances.put(key, distance);
            if (this.isSymmetric && this.distances.containsKey(revKey = RelationKey.newKey(to, from))) {
                this.distances.put(revKey, distance);
            }
            return this;
        }

        public Builder addTransportTime(String from, String to, double time) {
            RelationKey revKey;
            RelationKey key = RelationKey.newKey(from, to);
            if (!this.timesSet) {
                this.timesSet = true;
            }
            if (this.times.containsKey(key)) {
                log.warn("transport-time from " + from + " to " + to + " already exists. This overrides times.");
            }
            this.times.put(key, time);
            if (this.isSymmetric && this.times.containsKey(revKey = RelationKey.newKey(to, from))) {
                this.times.put(revKey, time);
            }
            return this;
        }

        public VehicleRoutingTransportCostsMatrix build() {
            return new VehicleRoutingTransportCostsMatrix(this);
        }
    }

    static class RelationKey {
        final String from;
        final String to;

        static RelationKey newKey(String from, String to) {
            return new RelationKey(from, to);
        }

        public RelationKey(String from, String to) {
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RelationKey other = (RelationKey)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals(other.to));
        }
    }
}

