/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.acceptor;

import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.acceptor.AcceptNewRemoveFirst;
import com.graphhopper.jsprit.core.algorithm.acceptor.SchrimpfAcceptance;
import com.graphhopper.jsprit.core.algorithm.box.GreedySchrimpfFactory;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.algorithm.listener.AlgorithmStartsListener;
import com.graphhopper.jsprit.core.algorithm.listener.IterationEndsListener;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.util.Solutions;
import java.util.Collection;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchrimpfInitialThresholdGenerator
implements AlgorithmStartsListener {
    private static Logger logger = LoggerFactory.getLogger((String)SchrimpfInitialThresholdGenerator.class.getName());
    private SchrimpfAcceptance schrimpfAcceptance;
    private int nOfRandomWalks;

    public SchrimpfInitialThresholdGenerator(SchrimpfAcceptance schrimpfAcceptance, int nOfRandomWalks) {
        this.schrimpfAcceptance = schrimpfAcceptance;
        this.nOfRandomWalks = nOfRandomWalks;
    }

    @Override
    public void informAlgorithmStarts(VehicleRoutingProblem problem, VehicleRoutingAlgorithm algorithm, Collection<VehicleRoutingProblemSolution> solutions) {
        logger.info("prepare schrimpfAcceptanceFunction, i.e. determine initial threshold");
        double now = System.currentTimeMillis();
        final double[] results = new double[this.nOfRandomWalks];
        Jsprit.Builder builder = new GreedySchrimpfFactory().createGreedyAlgorithmBuilder(problem);
        builder.setCustomAcceptor(new AcceptNewRemoveFirst(1));
        VehicleRoutingAlgorithm vra = builder.buildAlgorithm();
        vra.setMaxIterations(this.nOfRandomWalks);
        vra.getAlgorithmListeners().addListener(new IterationEndsListener(){

            @Override
            public void informIterationEnds(int iteration, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
                double result;
                results[iteration - 1] = result = Solutions.bestOf(solutions).getCost();
            }
        });
        vra.searchSolutions();
        StandardDeviation dev = new StandardDeviation();
        double standardDeviation = dev.evaluate(results);
        double initialThreshold = standardDeviation / 2.0;
        this.schrimpfAcceptance.setInitialThreshold(initialThreshold);
        logger.info("took {} seconds", (Object)(((double)System.currentTimeMillis() - now) / 1000.0));
        logger.debug("initial threshold: {}", (Object)initialThreshold);
        logger.info("---------------------------------------------------------------------");
    }
}

