/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculator;
import com.graphhopper.jsprit.core.problem.constraint.ConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.constraint.HardRouteConstraint;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import java.util.ArrayList;
import java.util.Collection;

abstract class AbstractInsertionCalculator
implements JobInsertionCostsCalculator {
    AbstractInsertionCalculator() {
    }

    InsertionData checkRouteContraints(JobInsertionContext insertionContext, ConstraintManager constraintManager) {
        for (HardRouteConstraint hardRouteConstraint : constraintManager.getHardRouteConstraints()) {
            if (hardRouteConstraint.fulfilled(insertionContext)) continue;
            InsertionData.NoInsertionFound emptyInsertionData = new InsertionData.NoInsertionFound();
            emptyInsertionData.addFailedConstrainName(hardRouteConstraint.getClass().getSimpleName());
            return emptyInsertionData;
        }
        return null;
    }

    HardActivityConstraint.ConstraintsStatus fulfilled(JobInsertionContext iFacts, TourActivity prevAct, TourActivity newAct, TourActivity nextAct, double prevActDepTime, Collection<String> failedActivityConstraints, ConstraintManager constraintManager) {
        HardActivityConstraint.ConstraintsStatus status;
        HardActivityConstraint.ConstraintsStatus notFulfilled = null;
        ArrayList<String> failed = new ArrayList<String>();
        for (HardActivityConstraint c : constraintManager.getCriticalHardActivityConstraints()) {
            status = c.fulfilled(iFacts, prevAct, newAct, nextAct, prevActDepTime);
            if (status.equals((Object)HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK)) {
                failedActivityConstraints.add(c.getClass().getSimpleName());
                return status;
            }
            if (!status.equals((Object)HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED)) continue;
            failed.add(c.getClass().getSimpleName());
            notFulfilled = status;
        }
        if (notFulfilled != null) {
            failedActivityConstraints.addAll(failed);
            return notFulfilled;
        }
        for (HardActivityConstraint c : constraintManager.getHighPrioHardActivityConstraints()) {
            status = c.fulfilled(iFacts, prevAct, newAct, nextAct, prevActDepTime);
            if (status.equals((Object)HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK)) {
                failedActivityConstraints.add(c.getClass().getSimpleName());
                return status;
            }
            if (!status.equals((Object)HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED)) continue;
            failed.add(c.getClass().getSimpleName());
            notFulfilled = status;
        }
        if (notFulfilled != null) {
            failedActivityConstraints.addAll(failed);
            return notFulfilled;
        }
        for (HardActivityConstraint constraint : constraintManager.getLowPrioHardActivityConstraints()) {
            status = constraint.fulfilled(iFacts, prevAct, newAct, nextAct, prevActDepTime);
            if (!status.equals((Object)HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK) && !status.equals((Object)HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED)) continue;
            failedActivityConstraints.add(constraint.getClass().getSimpleName());
            return status;
        }
        return HardActivityConstraint.ConstraintsStatus.FULFILLED;
    }
}

