/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.AbstractInsertionStrategy;
import com.graphhopper.jsprit.core.algorithm.recreate.AccordingToPriorities;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculator;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.util.NoiseMaker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BestInsertion
extends AbstractInsertionStrategy {
    private static Logger logger = LoggerFactory.getLogger(BestInsertion.class);
    private JobInsertionCostsCalculator bestInsertionCostCalculator;
    private NoiseMaker noiseMaker = new NoiseMaker(){

        @Override
        public double makeNoise() {
            return 0.0;
        }
    };

    public BestInsertion(JobInsertionCostsCalculator jobInsertionCalculator, VehicleRoutingProblem vehicleRoutingProblem) {
        super(vehicleRoutingProblem);
        this.bestInsertionCostCalculator = jobInsertionCalculator;
        logger.debug("initialise {}", (Object)this);
    }

    public String toString() {
        return "[name=bestInsertion]";
    }

    @Override
    public Collection<Job> insertUnassignedJobs(Collection<VehicleRoute> vehicleRoutes, Collection<Job> unassignedJobs) {
        ArrayList<Job> badJobs = new ArrayList<Job>(unassignedJobs.size());
        ArrayList<Job> unassignedJobList = new ArrayList<Job>(unassignedJobs);
        Collections.shuffle(unassignedJobList, this.random);
        Collections.sort(unassignedJobList, new AccordingToPriorities());
        for (Job unassignedJob : unassignedJobList) {
            AbstractInsertionStrategy.Insertion bestInsertion = null;
            InsertionData.NoInsertionFound empty = new InsertionData.NoInsertionFound();
            double bestInsertionCost = Double.MAX_VALUE;
            for (VehicleRoute vehicleRoute : vehicleRoutes) {
                InsertionData iData = this.bestInsertionCostCalculator.getInsertionData(vehicleRoute, unassignedJob, NO_NEW_VEHICLE_YET, -12345.12345, NO_NEW_DRIVER_YET, bestInsertionCost);
                if (iData instanceof InsertionData.NoInsertionFound) {
                    empty.getFailedConstraintNames().addAll(iData.getFailedConstraintNames());
                    continue;
                }
                if (!(iData.getInsertionCost() < bestInsertionCost + this.noiseMaker.makeNoise())) continue;
                bestInsertion = new AbstractInsertionStrategy.Insertion(vehicleRoute, iData);
                bestInsertionCost = iData.getInsertionCost();
            }
            VehicleRoute newRoute = VehicleRoute.emptyRoute();
            InsertionData newIData = this.bestInsertionCostCalculator.getInsertionData(newRoute, unassignedJob, NO_NEW_VEHICLE_YET, -12345.12345, NO_NEW_DRIVER_YET, bestInsertionCost);
            if (!(newIData instanceof InsertionData.NoInsertionFound)) {
                if (newIData.getInsertionCost() < bestInsertionCost + this.noiseMaker.makeNoise()) {
                    bestInsertion = new AbstractInsertionStrategy.Insertion(newRoute, newIData);
                    vehicleRoutes.add(newRoute);
                }
            } else {
                empty.getFailedConstraintNames().addAll(newIData.getFailedConstraintNames());
            }
            if (bestInsertion == null) {
                badJobs.add(unassignedJob);
                this.markUnassigned(unassignedJob, empty.getFailedConstraintNames());
                continue;
            }
            this.insertJob(unassignedJob, bestInsertion.getInsertionData(), bestInsertion.getRoute());
        }
        return badJobs;
    }
}

