/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.AbstractInsertionStrategy;
import com.graphhopper.jsprit.core.algorithm.recreate.AccordingToPriorities;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionListeners;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BestInsertionConcurrent
extends AbstractInsertionStrategy {
    private static Logger logger = LoggerFactory.getLogger(BestInsertionConcurrent.class);
    private static final double NO_NEW_DEPARTURE_TIME_YET = -12345.12345;
    private static final Vehicle NO_NEW_VEHICLE_YET = null;
    private static final Driver NO_NEW_DRIVER_YET = null;
    private InsertionListeners insertionsListeners = new InsertionListeners();
    private JobInsertionCostsCalculator bestInsertionCostCalculator;
    private int nuOfBatches;
    private ExecutorCompletionService<Insertion> completionService;

    public BestInsertionConcurrent(JobInsertionCostsCalculator jobInsertionCalculator, ExecutorService executorService, int nuOfBatches, VehicleRoutingProblem vehicleRoutingProblem) {
        super(vehicleRoutingProblem);
        this.nuOfBatches = nuOfBatches;
        this.bestInsertionCostCalculator = jobInsertionCalculator;
        this.completionService = new ExecutorCompletionService(executorService);
        logger.debug("initialise {}", (Object)this);
    }

    public String toString() {
        return "[name=bestInsertion]";
    }

    @Override
    public Collection<Job> insertUnassignedJobs(Collection<VehicleRoute> vehicleRoutes, Collection<Job> unassignedJobs) {
        ArrayList<Job> badJobs = new ArrayList<Job>(unassignedJobs.size());
        ArrayList<Job> unassignedJobList = new ArrayList<Job>(unassignedJobs);
        Collections.shuffle(unassignedJobList, this.random);
        Collections.sort(unassignedJobList, new AccordingToPriorities());
        List<Batch> batches = this.distributeRoutes(vehicleRoutes, this.nuOfBatches);
        ArrayList<String> failedConstraintNames = new ArrayList<String>();
        for (final Job unassignedJob : unassignedJobList) {
            Insertion bestInsertion = null;
            double bestInsertionCost = Double.MAX_VALUE;
            for (final Batch batch : batches) {
                this.completionService.submit(new Callable<Insertion>(){

                    @Override
                    public Insertion call() throws Exception {
                        return BestInsertionConcurrent.this.getBestInsertion(batch, unassignedJob);
                    }
                });
            }
            try {
                for (int i = 0; i < batches.size(); ++i) {
                    Future<Insertion> futureIData = this.completionService.take();
                    Insertion insertion = futureIData.get();
                    if (insertion.insertionData instanceof InsertionData.NoInsertionFound) {
                        failedConstraintNames.addAll(insertion.getInsertionData().getFailedConstraintNames());
                        continue;
                    }
                    if (!(insertion.getInsertionData().getInsertionCost() < bestInsertionCost)) continue;
                    bestInsertion = insertion;
                    bestInsertionCost = insertion.getInsertionData().getInsertionCost();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            VehicleRoute newRoute = VehicleRoute.emptyRoute();
            InsertionData newIData = this.bestInsertionCostCalculator.getInsertionData(newRoute, unassignedJob, NO_NEW_VEHICLE_YET, -12345.12345, NO_NEW_DRIVER_YET, bestInsertionCost);
            if (newIData.getInsertionCost() < bestInsertionCost) {
                bestInsertion = new Insertion(newRoute, newIData);
                vehicleRoutes.add(newRoute);
                batches.get((int)this.random.nextInt((int)batches.size())).routes.add(newRoute);
            }
            if (bestInsertion == null) {
                badJobs.add(unassignedJob);
                this.markUnassigned(unassignedJob, failedConstraintNames);
                continue;
            }
            this.insertJob(unassignedJob, bestInsertion.getInsertionData(), bestInsertion.getRoute());
        }
        return badJobs;
    }

    private Insertion getBestInsertion(Batch batch, Job unassignedJob) {
        Insertion bestInsertion = null;
        InsertionData.NoInsertionFound empty = new InsertionData.NoInsertionFound();
        double bestInsertionCost = Double.MAX_VALUE;
        for (VehicleRoute vehicleRoute : batch.routes) {
            InsertionData iData = this.bestInsertionCostCalculator.getInsertionData(vehicleRoute, unassignedJob, NO_NEW_VEHICLE_YET, -12345.12345, NO_NEW_DRIVER_YET, bestInsertionCost);
            if (iData instanceof InsertionData.NoInsertionFound) {
                empty.getFailedConstraintNames().addAll(iData.getFailedConstraintNames());
                continue;
            }
            if (!(iData.getInsertionCost() < bestInsertionCost)) continue;
            bestInsertion = new Insertion(vehicleRoute, iData);
            bestInsertionCost = iData.getInsertionCost();
        }
        if (bestInsertion == null) {
            return new Insertion(null, empty);
        }
        return bestInsertion;
    }

    private List<Batch> distributeRoutes(Collection<VehicleRoute> vehicleRoutes, int nuOfBatches) {
        ArrayList<Batch> batches = new ArrayList<Batch>();
        for (int i = 0; i < nuOfBatches; ++i) {
            batches.add(new Batch());
        }
        if (vehicleRoutes.size() < nuOfBatches) {
            int nOfNewRoutes = nuOfBatches - vehicleRoutes.size();
            for (int i = 0; i < nOfNewRoutes; ++i) {
                vehicleRoutes.add(VehicleRoute.emptyRoute());
            }
        } else {
            vehicleRoutes.add(VehicleRoute.emptyRoute());
        }
        int count = 0;
        for (VehicleRoute route : vehicleRoutes) {
            if (count == nuOfBatches) {
                count = 0;
            }
            ((Batch)batches.get((int)count)).routes.add(route);
            ++count;
        }
        return batches;
    }

    class Insertion {
        private final VehicleRoute route;
        private final InsertionData insertionData;

        public Insertion(VehicleRoute vehicleRoute, InsertionData insertionData) {
            this.route = vehicleRoute;
            this.insertionData = insertionData;
        }

        public VehicleRoute getRoute() {
            return this.route;
        }

        public InsertionData getInsertionData() {
            return this.insertionData;
        }
    }

    static class Batch {
        List<VehicleRoute> routes = new ArrayList<VehicleRoute>();

        Batch() {
        }
    }
}

