/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.SolutionCompletenessRatio;
import com.graphhopper.jsprit.core.problem.constraint.SoftRouteConstraint;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IncreasingAbsoluteFixedCosts
extends SolutionCompletenessRatio
implements SoftRouteConstraint {
    private static final Logger logger = LoggerFactory.getLogger(IncreasingAbsoluteFixedCosts.class);
    private double weightDeltaFixCost = 0.5;

    public IncreasingAbsoluteFixedCosts(int noJobs) {
        super(noJobs);
        logger.debug("initialise {}", (Object)this);
    }

    public void setWeightOfFixCost(double weight) {
        this.weightDeltaFixCost = weight;
        logger.debug("set weightOfFixCostSaving to {}", (Object)weight);
    }

    public String toString() {
        return "[name=IncreasingAbsoluteFixedCosts][weightOfFixedCostSavings=" + this.weightDeltaFixCost + "]";
    }

    @Override
    public double getCosts(JobInsertionContext insertionContext) {
        VehicleRoute currentRoute = insertionContext.getRoute();
        double currentFix = 0.0;
        if (currentRoute.getVehicle() != null && !(currentRoute.getVehicle() instanceof VehicleImpl.NoVehicle)) {
            currentFix = currentRoute.getVehicle().getType().getVehicleCostParams().fix;
        }
        double increasingAbsoluteFixedCosts = this.solutionCompletenessRatio * (insertionContext.getNewVehicle().getType().getVehicleCostParams().fix - currentFix);
        return this.weightDeltaFixCost * this.solutionCompletenessRatio * increasingAbsoluteFixedCosts;
    }
}

