/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.AbstractInsertionStrategy;
import com.graphhopper.jsprit.core.algorithm.recreate.DefaultScorer;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionDataUpdater;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.ScoredJob;
import com.graphhopper.jsprit.core.algorithm.recreate.ScoringFunction;
import com.graphhopper.jsprit.core.algorithm.recreate.VersionedInsertionData;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.DependencyType;
import com.graphhopper.jsprit.core.problem.job.Break;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleFleetManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegretInsertionConcurrentFast
extends AbstractInsertionStrategy {
    private static Logger logger = LoggerFactory.getLogger(RegretInsertionConcurrentFast.class);
    private ScoringFunction scoringFunction;
    private final JobInsertionCostsCalculator insertionCostsCalculator;
    private final ExecutorService executor;
    private VehicleFleetManager fleetManager;
    private Set<String> initialVehicleIds;
    private boolean switchAllowed = true;
    private DependencyType[] dependencyTypes = null;

    public void setScoringFunction(ScoringFunction scoringFunction) {
        this.scoringFunction = scoringFunction;
    }

    public RegretInsertionConcurrentFast(JobInsertionCostsCalculator jobInsertionCalculator, VehicleRoutingProblem vehicleRoutingProblem, ExecutorService executorService, VehicleFleetManager fleetManager) {
        super(vehicleRoutingProblem);
        this.scoringFunction = new DefaultScorer(vehicleRoutingProblem);
        this.insertionCostsCalculator = jobInsertionCalculator;
        this.vrp = vehicleRoutingProblem;
        this.executor = executorService;
        this.fleetManager = fleetManager;
        this.initialVehicleIds = this.getInitialVehicleIds(vehicleRoutingProblem);
        logger.debug("initialise " + this);
    }

    public String toString() {
        return "[name=regretInsertion][additionalScorer=" + this.scoringFunction + "]";
    }

    public void setSwitchAllowed(boolean switchAllowed) {
        this.switchAllowed = switchAllowed;
    }

    private Set<String> getInitialVehicleIds(VehicleRoutingProblem vehicleRoutingProblem) {
        HashSet<String> ids = new HashSet<String>();
        for (VehicleRoute r : vehicleRoutingProblem.getInitialVehicleRoutes()) {
            ids.add(r.getVehicle().getId());
        }
        return ids;
    }

    public void setDependencyTypes(DependencyType[] dependencyTypes) {
        this.dependencyTypes = dependencyTypes;
    }

    @Override
    public Collection<Job> insertUnassignedJobs(Collection<VehicleRoute> routes, Collection<Job> unassignedJobs) {
        ArrayList<Job> badJobs = new ArrayList<Job>(unassignedJobs.size());
        Iterator<Job> jobIterator = unassignedJobs.iterator();
        while (jobIterator.hasNext()) {
            Job job = jobIterator.next();
            if (!(job instanceof Break)) continue;
            VehicleRoute route = InsertionDataUpdater.findRoute(routes, job);
            if (route == null) {
                badJobs.add(job);
            } else {
                InsertionData iData = this.insertionCostsCalculator.getInsertionData(route, job, NO_NEW_VEHICLE_YET, -12345.12345, NO_NEW_DRIVER_YET, Double.MAX_VALUE);
                if (iData instanceof InsertionData.NoInsertionFound) {
                    badJobs.add(job);
                } else {
                    this.insertJob(job, iData, route);
                }
            }
            jobIterator.remove();
        }
        ArrayList<Job> jobs = new ArrayList<Job>(unassignedJobs);
        TreeSet[] priorityQueues = new TreeSet[this.vrp.getJobs().values().size() + 2];
        VehicleRoute lastModified = null;
        boolean firstRun = true;
        int updateRound = 0;
        HashMap<VehicleRoute, Integer> updates = new HashMap<VehicleRoute, Integer>();
        while (!jobs.isEmpty()) {
            ArrayList<Job> unassignedJobList = new ArrayList<Job>(jobs);
            ArrayList<ScoredJob> badJobList = new ArrayList<ScoredJob>();
            if (!firstRun && lastModified == null) {
                throw new IllegalStateException("ho. this must not be.");
            }
            this.updateInsertionData(priorityQueues, routes, unassignedJobList, updateRound, firstRun, lastModified, updates);
            if (firstRun) {
                firstRun = false;
            }
            ++updateRound;
            ScoredJob bestScoredJob = InsertionDataUpdater.getBest(this.switchAllowed, this.initialVehicleIds, this.fleetManager, this.insertionCostsCalculator, this.scoringFunction, priorityQueues, updates, unassignedJobList, badJobList);
            if (bestScoredJob != null) {
                if (bestScoredJob.isNewRoute()) {
                    routes.add(bestScoredJob.getRoute());
                }
                this.insertJob(bestScoredJob.getJob(), bestScoredJob.getInsertionData(), bestScoredJob.getRoute());
                jobs.remove(bestScoredJob.getJob());
                lastModified = bestScoredJob.getRoute();
            } else {
                lastModified = null;
            }
            for (ScoredJob bad : badJobList) {
                Job unassigned = bad.getJob();
                jobs.remove(unassigned);
                badJobs.add(unassigned);
                this.markUnassigned(unassigned, bad.getInsertionData().getFailedConstraintNames());
            }
        }
        return badJobs;
    }

    private void updateInsertionData(TreeSet<VersionedInsertionData>[] priorityQueues, Collection<VehicleRoute> routes, List<Job> unassignedJobList, int updateRound, boolean firstRun, VehicleRoute lastModified, Map<VehicleRoute, Integer> updates) {
        ArrayList<Callable<Boolean>> tasks = new ArrayList<Callable<Boolean>>();
        boolean updatedAllRoutes = false;
        for (Job unassignedJob : unassignedJobList) {
            if (priorityQueues[unassignedJob.getIndex()] == null) {
                priorityQueues[unassignedJob.getIndex()] = new TreeSet<VersionedInsertionData>(InsertionDataUpdater.getComparator());
            }
            if (firstRun) {
                updatedAllRoutes = true;
                this.makeCallables(tasks, updatedAllRoutes, priorityQueues[unassignedJob.getIndex()], updateRound, unassignedJob, routes, lastModified);
                continue;
            }
            if (this.dependencyTypes == null || this.dependencyTypes[unassignedJob.getIndex()] == null) {
                this.makeCallables(tasks, updatedAllRoutes, priorityQueues[unassignedJob.getIndex()], updateRound, unassignedJob, routes, lastModified);
                continue;
            }
            DependencyType dependencyType = this.dependencyTypes[unassignedJob.getIndex()];
            if (dependencyType.equals((Object)DependencyType.INTER_ROUTE) || dependencyType.equals((Object)DependencyType.INTRA_ROUTE)) {
                updatedAllRoutes = true;
                this.makeCallables(tasks, updatedAllRoutes, priorityQueues[unassignedJob.getIndex()], updateRound, unassignedJob, routes, lastModified);
                continue;
            }
            this.makeCallables(tasks, updatedAllRoutes, priorityQueues[unassignedJob.getIndex()], updateRound, unassignedJob, routes, lastModified);
        }
        if (updatedAllRoutes) {
            for (VehicleRoute r : routes) {
                updates.put(r, updateRound);
            }
        } else {
            updates.put(lastModified, updateRound);
        }
        try {
            this.executor.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void makeCallables(List<Callable<Boolean>> tasks, boolean updateAll, final TreeSet<VersionedInsertionData> priorityQueue, final int updateRound, final Job unassignedJob, final Collection<VehicleRoute> routes, final VehicleRoute lastModified) {
        if (updateAll) {
            tasks.add(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return InsertionDataUpdater.update(RegretInsertionConcurrentFast.this.switchAllowed, RegretInsertionConcurrentFast.this.initialVehicleIds, RegretInsertionConcurrentFast.this.fleetManager, RegretInsertionConcurrentFast.this.insertionCostsCalculator, priorityQueue, updateRound, unassignedJob, routes);
                }
            });
        } else {
            tasks.add(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return InsertionDataUpdater.update(RegretInsertionConcurrentFast.this.switchAllowed, RegretInsertionConcurrentFast.this.initialVehicleIds, RegretInsertionConcurrentFast.this.fleetManager, RegretInsertionConcurrentFast.this.insertionCostsCalculator, priorityQueue, updateRound, unassignedJob, Arrays.asList(lastModified));
                }
            });
        }
    }
}

