/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate.listener;

import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.BeforeJobInsertionListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionEndsListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionStartsListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.JobInsertedListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.JobUnassignedListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.VehicleSwitchedListener;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InsertionListeners {
    private Collection<InsertionListener> listeners = new ArrayList<InsertionListener>();

    public Collection<InsertionListener> getListeners() {
        return this.listeners;
    }

    public void informJobInserted(Job insertedJob, VehicleRoute inRoute, double additionalCosts, double additionalTime) {
        for (InsertionListener l : this.listeners) {
            if (!(l instanceof JobInsertedListener)) continue;
            ((JobInsertedListener)l).informJobInserted(insertedJob, inRoute, additionalCosts, additionalTime);
        }
    }

    public void informVehicleSwitched(VehicleRoute route, Vehicle oldVehicle, Vehicle newVehicle) {
        for (InsertionListener l : this.listeners) {
            if (!(l instanceof VehicleSwitchedListener)) continue;
            ((VehicleSwitchedListener)l).vehicleSwitched(route, oldVehicle, newVehicle);
        }
    }

    public void informBeforeJobInsertion(Job job, InsertionData data, VehicleRoute route) {
        for (InsertionListener l : this.listeners) {
            if (!(l instanceof BeforeJobInsertionListener)) continue;
            ((BeforeJobInsertionListener)l).informBeforeJobInsertion(job, data, route);
        }
    }

    public void informInsertionStarts(Collection<VehicleRoute> vehicleRoutes, Collection<Job> unassignedJobs) {
        for (InsertionListener l : this.listeners) {
            if (!(l instanceof InsertionStartsListener)) continue;
            ((InsertionStartsListener)l).informInsertionStarts(vehicleRoutes, unassignedJobs);
        }
    }

    public void informInsertionEndsListeners(Collection<VehicleRoute> vehicleRoutes) {
        for (InsertionListener l : this.listeners) {
            if (!(l instanceof InsertionEndsListener)) continue;
            ((InsertionEndsListener)l).informInsertionEnds(vehicleRoutes);
        }
    }

    public void informJobUnassignedListeners(Job unassigned, List<String> reasons) {
        for (InsertionListener l : this.listeners) {
            if (!(l instanceof JobUnassignedListener)) continue;
            ((JobUnassignedListener)l).informJobUnassigned(unassigned, reasons);
        }
    }

    public void addListener(InsertionListener insertionListener) {
        this.listeners.add(insertionListener);
    }

    public void removeListener(InsertionListener insertionListener) {
        this.listeners.remove(insertionListener);
    }

    public void addAllListeners(Collection<InsertionListener> listeners) {
        for (InsertionListener l : listeners) {
            this.addListener(l);
        }
    }
}

