/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.ruin;

import com.graphhopper.jsprit.core.algorithm.ruin.RuinShareFactory;
import com.graphhopper.jsprit.core.algorithm.ruin.RuinStrategy;
import com.graphhopper.jsprit.core.algorithm.ruin.listener.RuinListener;
import com.graphhopper.jsprit.core.algorithm.ruin.listener.RuinListeners;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.util.RandomNumberGeneration;
import java.util.Collection;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuinStrategy
implements RuinStrategy {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRuinStrategy.class);
    private RuinListeners ruinListeners;
    protected Random random = RandomNumberGeneration.getRandom();
    protected VehicleRoutingProblem vrp;
    protected RuinShareFactory ruinShareFactory;

    public void setRandom(Random random) {
        this.random = random;
    }

    public void setRuinShareFactory(RuinShareFactory ruinShareFactory) {
        this.ruinShareFactory = ruinShareFactory;
    }

    public RuinShareFactory getRuinShareFactory() {
        return this.ruinShareFactory;
    }

    protected AbstractRuinStrategy(VehicleRoutingProblem vrp) {
        this.vrp = vrp;
        this.ruinListeners = new RuinListeners();
    }

    @Override
    public Collection<Job> ruin(Collection<VehicleRoute> vehicleRoutes) {
        this.ruinListeners.ruinStarts(vehicleRoutes);
        Collection<Job> unassigned = this.ruinRoutes(vehicleRoutes);
        logger.trace("ruin: [ruined={}]", (Object)unassigned.size());
        this.ruinListeners.ruinEnds(vehicleRoutes, unassigned);
        return unassigned;
    }

    public abstract Collection<Job> ruinRoutes(Collection<VehicleRoute> var1);

    @Override
    public void addListener(RuinListener ruinListener) {
        this.ruinListeners.addListener(ruinListener);
    }

    @Override
    public void removeListener(RuinListener ruinListener) {
        this.ruinListeners.removeListener(ruinListener);
    }

    @Override
    public Collection<RuinListener> getListeners() {
        return this.ruinListeners.getListeners();
    }

    protected boolean removeJob(Job job, Collection<VehicleRoute> vehicleRoutes) {
        if (this.jobIsInitial(job)) {
            return false;
        }
        for (VehicleRoute route : vehicleRoutes) {
            if (!this.removeJob(job, route)) continue;
            return true;
        }
        return false;
    }

    private boolean jobIsInitial(Job job) {
        return !this.vrp.getJobs().containsKey(job.getId());
    }

    protected boolean removeJob(Job job, VehicleRoute route) {
        if (this.jobIsInitial(job)) {
            return false;
        }
        boolean removed = route.getTourActivities().removeJob(job);
        if (removed) {
            logger.trace("ruin: {}", (Object)job.getId());
            this.ruinListeners.removed(job, route);
            return true;
        }
        return false;
    }
}

