/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.ruin;

import com.graphhopper.jsprit.core.algorithm.ruin.AbstractRuinStrategy;
import com.graphhopper.jsprit.core.algorithm.ruin.RuinShareFactory;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuinRandom
extends AbstractRuinStrategy {
    private Logger logger = LoggerFactory.getLogger(RuinRandom.class);
    private VehicleRoutingProblem vrp;
    private double fractionOfAllNodes2beRuined;

    public RuinRandom(VehicleRoutingProblem vrp, double fraction) {
        super(vrp);
        this.vrp = vrp;
        this.fractionOfAllNodes2beRuined = fraction;
        this.setRuinShareFactory(new RuinShareFactory(){

            @Override
            public int createNumberToBeRemoved() {
                return RuinRandom.this.selectNuOfJobs2BeRemoved();
            }
        });
        this.logger.debug("initialise {}", (Object)this);
    }

    @Override
    public Collection<Job> ruinRoutes(Collection<VehicleRoute> vehicleRoutes) {
        ArrayList<Job> unassignedJobs = new ArrayList<Job>();
        int nOfJobs2BeRemoved = this.getRuinShareFactory().createNumberToBeRemoved();
        this.ruin(vehicleRoutes, nOfJobs2BeRemoved, unassignedJobs);
        return unassignedJobs;
    }

    private void ruin(Collection<VehicleRoute> vehicleRoutes, int nOfJobs2BeRemoved, List<Job> unassignedJobs) {
        ArrayList<Job> availableJobs = new ArrayList<Job>(this.vrp.getJobs().values());
        Collections.shuffle(availableJobs, this.random);
        int removed = 0;
        for (Job job : availableJobs) {
            if (removed == nOfJobs2BeRemoved) break;
            if (this.removeJob(job, vehicleRoutes)) {
                unassignedJobs.add(job);
            }
            ++removed;
        }
    }

    public String toString() {
        return "[name=randomRuin][noJobsToBeRemoved=" + this.selectNuOfJobs2BeRemoved() + "]";
    }

    private int selectNuOfJobs2BeRemoved() {
        return (int)Math.ceil((double)this.vrp.getJobs().values().size() * this.fractionOfAllNodes2beRuined);
    }
}

