/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.ruin;

import com.graphhopper.jsprit.core.algorithm.ruin.AbstractRuinStrategy;
import com.graphhopper.jsprit.core.algorithm.ruin.JobNeighborhoods;
import com.graphhopper.jsprit.core.algorithm.ruin.StringUtil;
import com.graphhopper.jsprit.core.problem.AbstractActivity;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.util.RandomUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuinString
extends AbstractRuinStrategy {
    private static Logger logger = LoggerFactory.getLogger(RuinString.class);
    private final VehicleRoutingProblem vrp;
    private final JobNeighborhoods jobNeighborhoods;
    private int kMin = 1;
    private int kMax = 6;
    private int lMin = 30;
    private int lMax = 60;

    public RuinString(VehicleRoutingProblem vrp, JobNeighborhoods jobNeighborhoods) {
        super(vrp);
        this.vrp = vrp;
        this.jobNeighborhoods = jobNeighborhoods;
        logger.debug("initialise {}", (Object)this);
    }

    public void setNoRoutes(int kMin, int kMax) {
        this.kMin = kMin;
        this.kMax = kMax;
    }

    public void setStringLength(int lMin, int lMax) {
        this.lMin = lMin;
        this.lMax = lMax;
    }

    public String toString() {
        return "[name=splitRuin]";
    }

    @Override
    public Collection<Job> ruinRoutes(Collection<VehicleRoute> vehicleRoutes) {
        if (vehicleRoutes.isEmpty() || this.vrp.getJobs().isEmpty()) {
            return Collections.emptyList();
        }
        int noStrings = this.kMin == this.kMax ? this.kMax : this.kMin + this.random.nextInt(this.kMax - this.kMin);
        noStrings = Math.min(noStrings, vehicleRoutes.size());
        HashSet<Job> unassignedJobs = new HashSet<Job>();
        HashSet<VehicleRoute> ruinedRoutes = new HashSet<VehicleRoute>();
        Job prevJob = RandomUtils.nextJob(this.vrp.getJobs().values(), this.random);
        Iterator<Job> neighborhoodIterator = this.jobNeighborhoods.getNearestNeighborsIterator(this.kMax * this.lMax, prevJob);
        while (neighborhoodIterator.hasNext() && ruinedRoutes.size() <= noStrings) {
            VehicleRoute route;
            if (!unassignedJobs.contains(prevJob) && (route = this.getRouteOf(prevJob, vehicleRoutes)) != null && !ruinedRoutes.contains(route)) {
                if (this.random.nextDouble() < 0.5) {
                    this.ruinRouteWithStringRuin(route, prevJob, unassignedJobs);
                } else {
                    this.ruinRouteWithSplitStringRuin(route, prevJob, unassignedJobs);
                }
                ruinedRoutes.add(route);
            }
            prevJob = neighborhoodIterator.next();
        }
        return unassignedJobs;
    }

    private VehicleRoute getRouteOf(Job job, Collection<VehicleRoute> vehicleRoutes) {
        for (VehicleRoute route : vehicleRoutes) {
            if (!route.getTourActivities().servesJob(job)) continue;
            return route;
        }
        return null;
    }

    private void ruinRouteWithSplitStringRuin(VehicleRoute seedRoute, Job prevJob, Set<Job> unassignedJobs) {
        int totalStringLength;
        List<Integer> stringBounds;
        int noActivities = seedRoute.getActivities().size();
        int stringLength = this.lMin == this.lMax ? this.lMin : this.lMin + this.random.nextInt(this.lMax - this.lMin);
        stringLength = Math.min(stringLength, seedRoute.getActivities().size());
        int preservedSubstringLength = StringUtil.determineSubstringLength(stringLength, noActivities, this.random);
        List<AbstractActivity> acts = this.vrp.getActivities(prevJob);
        AbstractActivity randomSeedAct = RandomUtils.nextItem(acts, this.random);
        int seedIndex = 0;
        int index = 0;
        for (TourActivity act : seedRoute.getActivities()) {
            if (act.getIndex() == randomSeedAct.getIndex()) {
                seedIndex = index;
                break;
            }
            ++index;
        }
        if ((stringBounds = StringUtil.getLowerBoundsOfAllStrings(totalStringLength = stringLength + preservedSubstringLength, seedIndex, noActivities)).isEmpty()) {
            return;
        }
        int lowerBound = RandomUtils.nextItem(stringBounds, this.random);
        ArrayList<Job> jobs2Remove = new ArrayList<Job>();
        int startIndexOfPreservedSubstring = this.random.nextInt(stringLength);
        int position = 0;
        int noStringsInPreservedSubstring = 0;
        boolean isPreservedSubstring = false;
        for (int i = lowerBound; i < lowerBound + totalStringLength; ++i) {
            if (position == startIndexOfPreservedSubstring) {
                isPreservedSubstring = true;
            }
            if (noStringsInPreservedSubstring >= preservedSubstringLength) {
                isPreservedSubstring = false;
            }
            if (!isPreservedSubstring) {
                TourActivity act = seedRoute.getActivities().get(i);
                if (act instanceof TourActivity.JobActivity) {
                    Job job = ((TourActivity.JobActivity)act).getJob();
                    if (this.vrp.getJobs().containsKey(job.getId())) {
                        jobs2Remove.add(job);
                    }
                }
            } else {
                ++noStringsInPreservedSubstring;
            }
            ++position;
        }
        for (Job job : jobs2Remove) {
            this.removeJob(job, seedRoute);
            unassignedJobs.add(job);
        }
    }

    private void ruinRouteWithStringRuin(VehicleRoute seedRoute, Job prevJob, Set<Job> unassignedJobs) {
        List<Integer> stringBounds;
        int stringLength = this.lMin + this.random.nextInt(this.lMax - this.lMin);
        stringLength = Math.min(stringLength, seedRoute.getActivities().size());
        List<AbstractActivity> acts = this.vrp.getActivities(prevJob);
        AbstractActivity randomSeedAct = RandomUtils.nextItem(acts, this.random);
        int seedIndex = 0;
        int noActivities = seedRoute.getActivities().size();
        int index = 0;
        for (TourActivity act : seedRoute.getActivities()) {
            if (act.getIndex() == randomSeedAct.getIndex()) {
                seedIndex = index;
                break;
            }
            ++index;
        }
        if ((stringBounds = StringUtil.getLowerBoundsOfAllStrings(stringLength, seedIndex, noActivities)).isEmpty()) {
            return;
        }
        int lowerBound = RandomUtils.nextItem(stringBounds, this.random);
        ArrayList<Job> jobs2Remove = new ArrayList<Job>();
        for (int i = lowerBound; i < lowerBound + stringLength; ++i) {
            TourActivity act = seedRoute.getActivities().get(i);
            if (!(act instanceof TourActivity.JobActivity)) continue;
            Job job = ((TourActivity.JobActivity)act).getJob();
            if (!this.vrp.getJobs().containsKey(job.getId())) continue;
            jobs2Remove.add(job);
        }
        for (Job job : jobs2Remove) {
            this.removeJob(job, seedRoute);
            unassignedJobs.add(job);
        }
    }
}

