/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.ruin.distance;

import com.graphhopper.jsprit.core.algorithm.ruin.distance.JobDistance;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.util.EuclideanDistanceCalculator;

public class AvgServiceAndShipmentDistance
implements JobDistance {
    private VehicleRoutingTransportCosts costs;

    public AvgServiceAndShipmentDistance(VehicleRoutingTransportCosts costs) {
        this.costs = costs;
    }

    @Override
    public double getDistance(Job i, Job j) {
        if (i.equals(j)) {
            return 0.0;
        }
        if (i instanceof Service && j instanceof Service) {
            return this.calcDist((Service)i, (Service)j);
        }
        if (i instanceof Service && j instanceof Shipment) {
            return this.calcDist((Service)i, (Shipment)j);
        }
        if (i instanceof Shipment && j instanceof Service) {
            return this.calcDist((Service)j, (Shipment)i);
        }
        if (i instanceof Shipment && j instanceof Shipment) {
            return this.calcDist((Shipment)i, (Shipment)j);
        }
        throw new IllegalStateException("this supports only shipments or services");
    }

    private double calcDist(Service i, Service j) {
        return this.calcDist(i.getLocation(), j.getLocation());
    }

    private double calcDist(Service i, Shipment j) {
        double c_ij1 = this.calcDist(i.getLocation(), j.getPickupLocation());
        double c_ij2 = this.calcDist(i.getLocation(), j.getDeliveryLocation());
        return (c_ij1 + c_ij2) / 2.0;
    }

    private double calcDist(Shipment i, Shipment j) {
        double c_i1j1 = this.calcDist(i.getPickupLocation(), j.getPickupLocation());
        double c_i1j2 = this.calcDist(i.getPickupLocation(), j.getDeliveryLocation());
        double c_i2j1 = this.calcDist(i.getDeliveryLocation(), j.getPickupLocation());
        double c_i2j2 = this.calcDist(i.getDeliveryLocation(), j.getDeliveryLocation());
        return (c_i1j1 + c_i1j2 + c_i2j1 + c_i2j2) / 4.0;
    }

    private double calcDist(Location location_i, Location location_j) {
        try {
            return this.costs.getTransportCost(location_i, location_j, 0.0, null, null);
        }
        catch (IllegalStateException illegalStateException) {
            return EuclideanDistanceCalculator.calculateDistance(location_i.getCoordinate(), location_j.getCoordinate());
        }
    }
}

