/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.state;

import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.algorithm.state.StateUpdater;
import com.graphhopper.jsprit.core.problem.Capacity;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;

class UpdateMaxCapacityUtilisationAtActivitiesByLookingBackwardInRoute
implements ActivityVisitor,
StateUpdater {
    private StateManager stateManager;
    private VehicleRoute route;
    private Capacity maxLoad;
    private Capacity defaultValue;

    public UpdateMaxCapacityUtilisationAtActivitiesByLookingBackwardInRoute(StateManager stateManager) {
        this.stateManager = stateManager;
        this.defaultValue = Capacity.Builder.newInstance().build();
    }

    @Override
    public void begin(VehicleRoute route) {
        this.route = route;
        this.maxLoad = this.stateManager.getRouteState(route, InternalStates.LOAD_AT_BEGINNING, Capacity.class);
        if (this.maxLoad == null) {
            this.maxLoad = this.defaultValue;
        }
    }

    @Override
    public void visit(TourActivity act) {
        this.maxLoad = Capacity.max(this.maxLoad, this.stateManager.getActivityState(act, InternalStates.LOAD, Capacity.class));
        this.stateManager.putInternalTypedActivityState(act, InternalStates.PAST_MAXLOAD, this.maxLoad);
    }

    @Override
    public void finish() {
    }
}

