/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem;

import java.util.Arrays;

public class Capacity {
    private int[] dimensions;

    public static Capacity addup(Capacity cap1, Capacity cap2) {
        if (cap1 == null || cap2 == null) {
            throw new NullPointerException("arguments must not be null");
        }
        Builder capacityBuilder = Builder.newInstance();
        for (int i = 0; i < Math.max(cap1.getNuOfDimensions(), cap2.getNuOfDimensions()); ++i) {
            capacityBuilder.addDimension(i, cap1.get(i) + cap2.get(i));
        }
        return capacityBuilder.build();
    }

    public static Capacity subtract(Capacity cap, Capacity cap2subtract) {
        if (cap == null || cap2subtract == null) {
            throw new NullPointerException("arguments must not be null");
        }
        Builder capacityBuilder = Builder.newInstance();
        for (int i = 0; i < Math.max(cap.getNuOfDimensions(), cap2subtract.getNuOfDimensions()); ++i) {
            int dimValue = cap.get(i) - cap2subtract.get(i);
            capacityBuilder.addDimension(i, dimValue);
        }
        return capacityBuilder.build();
    }

    public static Capacity invert(Capacity cap2invert) {
        if (cap2invert == null) {
            throw new NullPointerException("arguments must not be null");
        }
        Builder capacityBuilder = Builder.newInstance();
        for (int i = 0; i < cap2invert.getNuOfDimensions(); ++i) {
            int dimValue = cap2invert.get(i) * -1;
            capacityBuilder.addDimension(i, dimValue);
        }
        return capacityBuilder.build();
    }

    public static double divide(Capacity numerator, Capacity denominator) {
        int nuOfDimensions = 0;
        double sumQuotients = 0.0;
        for (int index = 0; index < Math.max(numerator.getNuOfDimensions(), denominator.getNuOfDimensions()); ++index) {
            if (numerator.get(index) != 0 && denominator.get(index) == 0) {
                throw new IllegalArgumentException("numerator > 0 and denominator = 0. cannot divide by 0");
            }
            if (numerator.get(index) == 0 && denominator.get(index) == 0) continue;
            ++nuOfDimensions;
            sumQuotients += (double)numerator.get(index) / (double)denominator.get(index);
        }
        if (nuOfDimensions > 0) {
            return sumQuotients / (double)nuOfDimensions;
        }
        return 0.0;
    }

    public static Capacity copyOf(Capacity capacity) {
        if (capacity == null) {
            return null;
        }
        return new Capacity(capacity);
    }

    Capacity(Capacity capacity) {
        this.dimensions = new int[capacity.getNuOfDimensions()];
        for (int i = 0; i < capacity.getNuOfDimensions(); ++i) {
            this.dimensions[i] = capacity.get(i);
        }
    }

    Capacity(Builder builder) {
        this.dimensions = builder.dimensions;
    }

    public int getNuOfDimensions() {
        return this.dimensions.length;
    }

    public int get(int index) {
        if (index < this.dimensions.length) {
            return this.dimensions[index];
        }
        return 0;
    }

    public boolean isLessOrEqual(Capacity toCompare) {
        if (toCompare == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.getNuOfDimensions(); ++i) {
            if (this.get(i) <= toCompare.get(i)) continue;
            return false;
        }
        return true;
    }

    public boolean isGreaterOrEqual(Capacity toCompare) {
        if (toCompare == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < Math.max(this.getNuOfDimensions(), toCompare.getNuOfDimensions()); ++i) {
            if (this.get(i) >= toCompare.get(i)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String string = "[noDimensions=" + this.getNuOfDimensions() + "]";
        for (int i = 0; i < this.getNuOfDimensions(); ++i) {
            string = string + "[[dimIndex=" + i + "][dimValue=" + this.dimensions[i] + "]]";
        }
        return string;
    }

    public static Capacity max(Capacity cap1, Capacity cap2) {
        if (cap1 == null || cap2 == null) {
            throw new IllegalArgumentException("arg must not be null");
        }
        Builder toReturnBuilder = Builder.newInstance();
        for (int i = 0; i < Math.max(cap1.getNuOfDimensions(), cap2.getNuOfDimensions()); ++i) {
            toReturnBuilder.addDimension(i, Math.max(cap1.get(i), cap2.get(i)));
        }
        return toReturnBuilder.build();
    }

    public static Capacity min(Capacity cap1, Capacity cap2) {
        if (cap1 == null || cap2 == null) {
            throw new IllegalArgumentException("arg must not be null");
        }
        Builder toReturnBuilder = Builder.newInstance();
        for (int i = 0; i < Math.max(cap1.getNuOfDimensions(), cap2.getNuOfDimensions()); ++i) {
            toReturnBuilder.addDimension(i, Math.min(cap1.get(i), cap2.get(i)));
        }
        return toReturnBuilder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Capacity)) {
            return false;
        }
        Capacity capacity = (Capacity)o;
        return Arrays.equals(this.dimensions, capacity.dimensions);
    }

    public int hashCode() {
        return Arrays.hashCode(this.dimensions);
    }

    public static class Builder {
        private int[] dimensions = new int[1];

        public static Builder newInstance() {
            return new Builder();
        }

        Builder() {
        }

        public Builder addDimension(int index, int dimValue) {
            if (index < this.dimensions.length) {
                this.dimensions[index] = dimValue;
            } else {
                int requiredSize = index + 1;
                int[] newDimensions = new int[requiredSize];
                this.copy(this.dimensions, newDimensions);
                newDimensions[index] = dimValue;
                this.dimensions = newDimensions;
            }
            return this;
        }

        private void copy(int[] from, int[] to) {
            for (int i = 0; i < this.dimensions.length; ++i) {
                to[i] = from[i];
            }
        }

        public Capacity build() {
            return new Capacity(this);
        }
    }
}

