/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.constraint;

import com.graphhopper.jsprit.core.algorithm.state.StateId;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.cost.TransportDistance;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.activity.DeliverShipment;
import com.graphhopper.jsprit.core.problem.solution.route.activity.End;
import com.graphhopper.jsprit.core.problem.solution.route.activity.Start;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import java.util.Collection;
import java.util.Map;

public class MaxDistanceConstraint
implements HardActivityConstraint {
    private StateManager stateManager;
    private StateId distanceId;
    private TransportDistance distanceCalculator;
    private Double[] maxDistances;

    public MaxDistanceConstraint(StateManager stateManager, StateId distanceId, TransportDistance distanceCalculator, Map<Vehicle, Double> maxDistancePerVehicleMap) {
        this.stateManager = stateManager;
        this.distanceId = distanceId;
        this.distanceCalculator = distanceCalculator;
        this.makeArray(maxDistancePerVehicleMap);
    }

    private void makeArray(Map<Vehicle, Double> maxDistances) {
        int maxIndex = this.getMaxIndex(maxDistances.keySet());
        this.maxDistances = new Double[maxIndex + 1];
        for (Vehicle v : maxDistances.keySet()) {
            this.maxDistances[v.getIndex()] = maxDistances.get(v);
        }
    }

    private int getMaxIndex(Collection<Vehicle> vehicles) {
        int index = 0;
        for (Vehicle v : vehicles) {
            if (v.getIndex() <= index) continue;
            index = v.getIndex();
        }
        return index;
    }

    @Override
    public HardActivityConstraint.ConstraintsStatus fulfilled(JobInsertionContext iFacts, TourActivity prevAct, TourActivity newAct, TourActivity nextAct, double prevActDepTime) {
        if (!this.hasMaxDistance(iFacts.getNewVehicle())) {
            return HardActivityConstraint.ConstraintsStatus.FULFILLED;
        }
        Double currentDistance = 0.0;
        boolean routeIsEmpty = iFacts.getRoute().isEmpty();
        if (!routeIsEmpty) {
            currentDistance = this.stateManager.getRouteState(iFacts.getRoute(), iFacts.getNewVehicle(), this.distanceId, Double.class);
        }
        double maxDistance = this.getMaxDistance(iFacts.getNewVehicle());
        if (currentDistance > maxDistance) {
            return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK;
        }
        double distancePrevAct2NewAct = this.distanceCalculator.getDistance(prevAct.getLocation(), newAct.getLocation(), iFacts.getNewDepTime(), iFacts.getNewVehicle());
        double distanceNewAct2nextAct = this.distanceCalculator.getDistance(newAct.getLocation(), nextAct.getLocation(), iFacts.getNewDepTime(), iFacts.getNewVehicle());
        double distancePrevAct2NextAct = this.distanceCalculator.getDistance(prevAct.getLocation(), nextAct.getLocation(), prevActDepTime, iFacts.getNewVehicle());
        if (prevAct instanceof Start && nextAct instanceof End) {
            distancePrevAct2NextAct = 0.0;
        }
        if (nextAct instanceof End && !iFacts.getNewVehicle().isReturnToDepot()) {
            distanceNewAct2nextAct = 0.0;
            distancePrevAct2NextAct = 0.0;
        }
        double additionalDistance = distancePrevAct2NewAct + distanceNewAct2nextAct - distancePrevAct2NextAct;
        if (currentDistance + additionalDistance > maxDistance) {
            return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
        }
        double additionalDistanceOfPickup = 0.0;
        if (newAct instanceof DeliverShipment) {
            int iIndexOfPickup = iFacts.getRelatedActivityContext().getInsertionIndex();
            TourActivity pickup = iFacts.getAssociatedActivities().get(0);
            TourActivity actBeforePickup = iIndexOfPickup > 0 ? iFacts.getRoute().getActivities().get(iIndexOfPickup - 1) : new Start(iFacts.getNewVehicle().getStartLocation(), 0.0, Double.MAX_VALUE);
            TourActivity actAfterPickup = iIndexOfPickup < iFacts.getRoute().getActivities().size() ? iFacts.getRoute().getActivities().get(iIndexOfPickup) : nextAct;
            double distanceActBeforePickup2Pickup = this.distanceCalculator.getDistance(actBeforePickup.getLocation(), pickup.getLocation(), actBeforePickup.getEndTime(), iFacts.getNewVehicle());
            double distancePickup2ActAfterPickup = this.distanceCalculator.getDistance(pickup.getLocation(), actAfterPickup.getLocation(), iFacts.getRelatedActivityContext().getEndTime(), iFacts.getNewVehicle());
            double distanceBeforePickup2AfterPickup = this.distanceCalculator.getDistance(actBeforePickup.getLocation(), actAfterPickup.getLocation(), actBeforePickup.getEndTime(), iFacts.getNewVehicle());
            if (routeIsEmpty) {
                distanceBeforePickup2AfterPickup = 0.0;
            }
            if (actAfterPickup instanceof End && !iFacts.getNewVehicle().isReturnToDepot()) {
                distancePickup2ActAfterPickup = 0.0;
                distanceBeforePickup2AfterPickup = 0.0;
            }
            additionalDistanceOfPickup = distanceActBeforePickup2Pickup + distancePickup2ActAfterPickup - distanceBeforePickup2AfterPickup;
        }
        if (currentDistance + additionalDistance + additionalDistanceOfPickup > maxDistance) {
            return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
        }
        return HardActivityConstraint.ConstraintsStatus.FULFILLED;
    }

    private boolean hasMaxDistance(Vehicle newVehicle) {
        if (newVehicle.getIndex() >= this.maxDistances.length) {
            return false;
        }
        return this.maxDistances[newVehicle.getIndex()] != null;
    }

    private double getMaxDistance(Vehicle newVehicle) {
        Double maxDistance = this.maxDistances[newVehicle.getIndex()];
        if (maxDistance == null) {
            return Double.MAX_VALUE;
        }
        return maxDistance;
    }
}

