/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.constraint;

import com.graphhopper.jsprit.core.algorithm.state.StateId;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.cost.TransportTime;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingActivityCosts;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.activity.DeliveryActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.End;
import com.graphhopper.jsprit.core.problem.solution.route.activity.PickupActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import java.util.Collections;
import java.util.Map;

public class MaxTimeInVehicleConstraint
implements HardActivityConstraint {
    private final VehicleRoutingProblem vrp;
    private final TransportTime transportTime;
    private final VehicleRoutingActivityCosts activityCosts;
    private final StateId minSlackId;
    private final StateId openJobsId;
    private final StateManager stateManager;

    public MaxTimeInVehicleConstraint(TransportTime transportTime, VehicleRoutingActivityCosts activityCosts, StateId minSlackId, StateManager stateManager, VehicleRoutingProblem vrp, StateId openJobsId) {
        this.transportTime = transportTime;
        this.minSlackId = minSlackId;
        this.stateManager = stateManager;
        this.activityCosts = activityCosts;
        this.vrp = vrp;
        this.openJobsId = openJobsId;
    }

    @Override
    public HardActivityConstraint.ConstraintsStatus fulfilled(JobInsertionContext iFacts, TourActivity prevAct, TourActivity newAct, TourActivity nextAct, double prevActDepTime) {
        double directArrTimeNextAct;
        double directNextActStart;
        double additionalTimeOfNewAct;
        boolean newActIsPickup = newAct instanceof PickupActivity;
        boolean newActIsDelivery = newAct instanceof DeliveryActivity;
        double newActArrival = prevActDepTime + this.transportTime.getTransportTime(prevAct.getLocation(), newAct.getLocation(), prevActDepTime, iFacts.getNewDriver(), iFacts.getNewVehicle());
        double newActStart = Math.max(newActArrival, newAct.getTheoreticalEarliestOperationStartTime());
        double newActDeparture = newActStart + this.activityCosts.getActivityDuration(newAct, newActArrival, iFacts.getNewDriver(), iFacts.getNewVehicle());
        double nextActArrival = newActDeparture + this.transportTime.getTransportTime(newAct.getLocation(), nextAct.getLocation(), newActDeparture, iFacts.getNewDriver(), iFacts.getNewVehicle());
        double nextActStart = Math.max(nextActArrival, nextAct.getTheoreticalEarliestOperationStartTime());
        if (newAct instanceof DeliveryActivity) {
            double maxTimeInVehicle;
            double pickupEnd = iFacts.getAssociatedActivities().size() == 1 ? iFacts.getNewDepTime() : iFacts.getRelatedActivityContext().getEndTime();
            double timeInVehicle = newActStart - pickupEnd;
            if (timeInVehicle > (maxTimeInVehicle = ((TourActivity.JobActivity)newAct).getJob().getMaxTimeInVehicle())) {
                return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
            }
        } else if (newActIsPickup && iFacts.getAssociatedActivities().size() == 1) {
            double maxTimeInVehicle = ((TourActivity.JobActivity)newAct).getJob().getMaxTimeInVehicle();
            double nextActDeparture = nextActStart + this.activityCosts.getActivityDuration(nextAct, nextActArrival, iFacts.getNewDriver(), iFacts.getNewVehicle());
            double timeToEnd = 0.0;
            if (timeToEnd > maxTimeInVehicle) {
                return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
            }
        }
        double minSlack = Double.MAX_VALUE;
        if (!(nextAct instanceof End)) {
            minSlack = this.stateManager.getActivityState(nextAct, iFacts.getNewVehicle(), this.minSlackId, Double.class);
        }
        if ((additionalTimeOfNewAct = nextActStart - prevActDepTime - ((directNextActStart = Math.max(directArrTimeNextAct = prevActDepTime + this.transportTime.getTransportTime(prevAct.getLocation(), nextAct.getLocation(), prevActDepTime, iFacts.getNewDriver(), iFacts.getNewVehicle()), nextAct.getTheoreticalEarliestOperationStartTime())) - prevActDepTime)) > minSlack) {
            if (newActIsPickup) {
                return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
            }
            return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
        }
        if (newActIsDelivery) {
            Map openJobsAtNext = nextAct instanceof End ? this.stateManager.getRouteState(iFacts.getRoute(), iFacts.getNewVehicle(), this.openJobsId, Map.class) : this.stateManager.getActivityState(nextAct, iFacts.getNewVehicle(), this.openJobsId, Map.class);
            if (openJobsAtNext == null) {
                openJobsAtNext = Collections.emptyMap();
            }
            for (Job openJob : openJobsAtNext.keySet()) {
                double slack = (Double)openJobsAtNext.get(openJob);
                double additionalTimeOfNewJob = additionalTimeOfNewAct;
                if (openJob instanceof Shipment) {
                    Map openJobsAtNextOfPickup = Collections.emptyMap();
                    TourActivity nextAfterPickup = iFacts.getAssociatedActivities().size() == 1 && !iFacts.getRoute().isEmpty() ? iFacts.getRoute().getActivities().get(0) : iFacts.getRoute().getActivities().get(iFacts.getRelatedActivityContext().getInsertionIndex());
                    if (nextAfterPickup != null) {
                        openJobsAtNextOfPickup = this.stateManager.getActivityState(nextAfterPickup, iFacts.getNewVehicle(), this.openJobsId, Map.class);
                    }
                    if (openJobsAtNextOfPickup.containsKey(openJob)) {
                        TourActivity pickupAct = iFacts.getAssociatedActivities().get(0);
                        double pickupActArrTime = iFacts.getRelatedActivityContext().getArrivalTime();
                        double pickupActEndTime = this.startOf(pickupAct, pickupActArrTime) + this.activityCosts.getActivityDuration(pickupAct, pickupActArrTime, iFacts.getNewDriver(), iFacts.getNewVehicle());
                        double nextAfterPickupArr = pickupActEndTime + this.transportTime.getTransportTime(pickupAct.getLocation(), nextAfterPickup.getLocation(), pickupActArrTime, iFacts.getNewDriver(), iFacts.getNewVehicle());
                        additionalTimeOfNewJob += this.startOf(nextAfterPickup, nextAfterPickupArr) - this.startOf(nextAfterPickup, nextAfterPickup.getArrTime());
                    }
                }
                if (!(additionalTimeOfNewJob > slack)) continue;
                return HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED;
            }
        }
        return HardActivityConstraint.ConstraintsStatus.FULFILLED;
    }

    private double startOf(TourActivity act, double arrTime) {
        return Math.max(arrTime, act.getTheoreticalEarliestOperationStartTime());
    }
}

