/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.solution.route;

import com.graphhopper.jsprit.core.problem.solution.route.RouteVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ReverseActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ReverseRouteActivityVisitor
implements RouteVisitor {
    private Collection<ReverseActivityVisitor> visitors = new ArrayList<ReverseActivityVisitor>();

    @Override
    public void visit(VehicleRoute route) {
        if (this.visitors.isEmpty()) {
            return;
        }
        if (route.isEmpty()) {
            return;
        }
        this.begin(route);
        Iterator<TourActivity> revIterator = route.getTourActivities().reverseActivityIterator();
        while (revIterator.hasNext()) {
            TourActivity act = revIterator.next();
            this.visit(act);
        }
        this.finish(route);
    }

    private void finish(VehicleRoute route) {
        for (ReverseActivityVisitor visitor : this.visitors) {
            visitor.finish();
        }
    }

    private void visit(TourActivity act) {
        for (ReverseActivityVisitor visitor : this.visitors) {
            visitor.visit(act);
        }
    }

    private void begin(VehicleRoute route) {
        for (ReverseActivityVisitor visitor : this.visitors) {
            visitor.begin(route);
        }
    }

    public void addActivityVisitor(ReverseActivityVisitor activityVisitor) {
        if (!this.visitors.contains(activityVisitor)) {
            this.visitors.add(activityVisitor);
        }
    }
}

