/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.acceptor;

import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.acceptor.AcceptNewRemoveFirst;
import com.graphhopper.jsprit.core.algorithm.acceptor.SolutionAcceptor;
import com.graphhopper.jsprit.core.algorithm.box.GreedySchrimpfFactory;
import com.graphhopper.jsprit.core.algorithm.box.Jsprit;
import com.graphhopper.jsprit.core.algorithm.listener.AlgorithmStartsListener;
import com.graphhopper.jsprit.core.algorithm.listener.IterationEndsListener;
import com.graphhopper.jsprit.core.algorithm.listener.IterationStartsListener;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.util.Solutions;
import java.util.Collection;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentalSchrimpfAcceptance
implements SolutionAcceptor,
IterationStartsListener,
AlgorithmStartsListener {
    static final Logger logger = LoggerFactory.getLogger((String)ExperimentalSchrimpfAcceptance.class.getName());
    private final double alpha;
    private int nOfTotalIterations = 1000;
    private int currentIteration = 0;
    private double initialThreshold = 0.0;
    private final int nOfRandomWalks;
    private final int solutionMemory;

    public ExperimentalSchrimpfAcceptance(int solutionMemory, double alpha, int nOfWarmupIterations) {
        this.alpha = alpha;
        this.nOfRandomWalks = nOfWarmupIterations;
        this.solutionMemory = solutionMemory;
        logger.info("initialise {}", (Object)this);
    }

    @Override
    public boolean acceptSolution(Collection<VehicleRoutingProblemSolution> solutions, VehicleRoutingProblemSolution newSolution) {
        boolean solutionAccepted = false;
        if (solutions.size() < this.solutionMemory) {
            solutions.add(newSolution);
            solutionAccepted = true;
        } else {
            VehicleRoutingProblemSolution worst = null;
            double threshold = this.getThreshold(this.currentIteration);
            for (VehicleRoutingProblemSolution solutionInMemory : solutions) {
                if (worst == null) {
                    worst = solutionInMemory;
                    continue;
                }
                if (!(solutionInMemory.getCost() > worst.getCost())) continue;
                worst = solutionInMemory;
            }
            if (newSolution.getRoutes().size() < worst.getRoutes().size()) {
                solutions.remove(worst);
                solutions.add(newSolution);
                solutionAccepted = true;
            } else if (newSolution.getRoutes().size() == worst.getRoutes().size() && newSolution.getCost() < worst.getCost() + threshold) {
                solutions.remove(worst);
                solutions.add(newSolution);
                solutionAccepted = true;
            }
        }
        return solutionAccepted;
    }

    public String toString() {
        return "[name=schrimpfAcceptanceFunction][alpha=" + this.alpha + "][warmup=" + this.nOfRandomWalks + "]";
    }

    private double getThreshold(int iteration) {
        double scheduleVariable = (double)iteration / (double)this.nOfTotalIterations;
        double currentThreshold = this.initialThreshold * Math.exp(-Math.log(2.0) * scheduleVariable / this.alpha);
        return currentThreshold;
    }

    @Override
    public void informAlgorithmStarts(VehicleRoutingProblem problem, VehicleRoutingAlgorithm algorithm, Collection<VehicleRoutingProblemSolution> solutions) {
        this.reset();
        logger.info("---------------------------------------------------------------------");
        logger.info("prepare schrimpfAcceptanceFunction, i.e. determine initial threshold");
        logger.info("start random-walk (see randomWalk.xml)");
        double now = System.currentTimeMillis();
        this.nOfTotalIterations = algorithm.getMaxIterations();
        final double[] results = new double[this.nOfRandomWalks];
        Jsprit.Builder builder = new GreedySchrimpfFactory().createGreedyAlgorithmBuilder(problem);
        builder.setCustomAcceptor(new AcceptNewRemoveFirst(1));
        VehicleRoutingAlgorithm vra = builder.buildAlgorithm();
        vra.setMaxIterations(this.nOfRandomWalks);
        vra.getAlgorithmListeners().addListener(new IterationEndsListener(){

            @Override
            public void informIterationEnds(int iteration, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
                double result;
                results[iteration - 1] = result = Solutions.bestOf(solutions).getCost();
            }
        });
        vra.searchSolutions();
        StandardDeviation dev = new StandardDeviation();
        double standardDeviation = dev.evaluate(results);
        this.initialThreshold = standardDeviation / 2.0;
        logger.info("warmup done");
        logger.info("total time: {}s", (Object)(((double)System.currentTimeMillis() - now) / 1000.0));
        logger.info("initial threshold: {}", (Object)this.initialThreshold);
        logger.info("---------------------------------------------------------------------");
    }

    private void reset() {
        this.currentIteration = 0;
    }

    @Override
    public void informIterationStarts(int i, VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        this.currentIteration = i;
    }
}

