/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingActivityCosts;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.solution.route.activity.End;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import java.util.Iterator;
import java.util.List;

final class AuxilliaryCostCalculator {
    private final VehicleRoutingTransportCosts routingCosts;
    private final VehicleRoutingActivityCosts activityCosts;

    public AuxilliaryCostCalculator(VehicleRoutingTransportCosts routingCosts, VehicleRoutingActivityCosts actCosts) {
        this.routingCosts = routingCosts;
        this.activityCosts = actCosts;
    }

    public double costOfPath(List<TourActivity> path, double depTime, Driver driver, Vehicle vehicle) {
        if (path.isEmpty()) {
            return 0.0;
        }
        double cost = 0.0;
        Iterator<TourActivity> actIter = path.iterator();
        TourActivity prevAct = actIter.next();
        double startCost = 0.0;
        cost += startCost;
        double departureTimePrevAct = depTime;
        while (actIter.hasNext()) {
            TourActivity act = actIter.next();
            if (act instanceof End && !vehicle.isReturnToDepot()) {
                return cost;
            }
            double transportCost = this.routingCosts.getTransportCost(prevAct.getLocation(), act.getLocation(), departureTimePrevAct, driver, vehicle);
            double transportTime = this.routingCosts.getTransportTime(prevAct.getLocation(), act.getLocation(), departureTimePrevAct, driver, vehicle);
            cost += transportCost;
            double actStartTime = departureTimePrevAct + transportTime;
            departureTimePrevAct = Math.max(actStartTime, act.getTheoreticalEarliestOperationStartTime()) + this.activityCosts.getActivityDuration(act, actStartTime, driver, vehicle);
            cost += this.activityCosts.getActivityCost(act, actStartTime, driver, vehicle);
            prevAct = act;
        }
        return cost;
    }
}

