/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.LocalActivityInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.InsertionStartsListener;
import com.graphhopper.jsprit.core.algorithm.recreate.listener.JobInsertedListener;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import java.util.Collection;

public class ConfigureLocalActivityInsertionCalculator
implements InsertionStartsListener,
JobInsertedListener {
    private VehicleRoutingProblem vrp;
    private LocalActivityInsertionCostsCalculator localActivityInsertionCostsCalculator;
    private int nuOfJobsToRecreate;

    public ConfigureLocalActivityInsertionCalculator(VehicleRoutingProblem vrp, LocalActivityInsertionCostsCalculator localActivityInsertionCostsCalculator) {
        this.vrp = vrp;
        this.localActivityInsertionCostsCalculator = localActivityInsertionCostsCalculator;
    }

    @Override
    public void informInsertionStarts(Collection<VehicleRoute> vehicleRoutes, Collection<Job> unassignedJobs) {
        this.nuOfJobsToRecreate = unassignedJobs.size();
        double completenessRatio = 1.0 - (double)this.nuOfJobsToRecreate / (double)this.vrp.getJobs().values().size();
        this.localActivityInsertionCostsCalculator.setSolutionCompletenessRatio(Math.max(0.5, completenessRatio));
    }

    @Override
    public void informJobInserted(Job job2insert, VehicleRoute inRoute, double additionalCosts, double additionalTime) {
        --this.nuOfJobsToRecreate;
        double completenessRatio = 1.0 - (double)this.nuOfJobsToRecreate / (double)this.vrp.getJobs().values().size();
        this.localActivityInsertionCostsCalculator.setSolutionCompletenessRatio(Math.max(0.5, completenessRatio));
    }
}

