/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.AbstractInsertionStrategy;
import com.graphhopper.jsprit.core.algorithm.recreate.DefaultScorer;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.RegretInsertionFast;
import com.graphhopper.jsprit.core.algorithm.recreate.ScoredJob;
import com.graphhopper.jsprit.core.algorithm.recreate.Scorer;
import com.graphhopper.jsprit.core.algorithm.recreate.ScoringFunction;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Break;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegretInsertion
extends AbstractInsertionStrategy {
    private static Logger logger = LoggerFactory.getLogger(RegretInsertionFast.class);
    private ScoringFunction scoringFunction;
    private JobInsertionCostsCalculator insertionCostsCalculator;

    public void setScoringFunction(ScoringFunction scoringFunction) {
        this.scoringFunction = scoringFunction;
    }

    public RegretInsertion(JobInsertionCostsCalculator jobInsertionCalculator, VehicleRoutingProblem vehicleRoutingProblem) {
        super(vehicleRoutingProblem);
        this.scoringFunction = new DefaultScorer(vehicleRoutingProblem);
        this.insertionCostsCalculator = jobInsertionCalculator;
        this.vrp = vehicleRoutingProblem;
        logger.debug("initialise {}", (Object)this);
    }

    public String toString() {
        return "[name=regretInsertion][additionalScorer=" + this.scoringFunction + "]";
    }

    @Override
    public Collection<Job> insertUnassignedJobs(Collection<VehicleRoute> routes, Collection<Job> unassignedJobs) {
        ArrayList<Job> badJobs = new ArrayList<Job>(unassignedJobs.size());
        Iterator<Job> jobIterator = unassignedJobs.iterator();
        while (jobIterator.hasNext()) {
            Job job = jobIterator.next();
            if (!(job instanceof Break)) continue;
            VehicleRoute route = this.findRoute(routes, job);
            if (route == null) {
                badJobs.add(job);
            } else {
                InsertionData iData = this.insertionCostsCalculator.getInsertionData(route, job, NO_NEW_VEHICLE_YET, -12345.12345, NO_NEW_DRIVER_YET, Double.MAX_VALUE);
                if (iData instanceof InsertionData.NoInsertionFound) {
                    badJobs.add(job);
                } else {
                    this.insertJob(job, iData, route);
                }
            }
            jobIterator.remove();
        }
        ArrayList<Job> jobs = new ArrayList<Job>(unassignedJobs);
        while (!jobs.isEmpty()) {
            ArrayList<Job> unassignedJobList = new ArrayList<Job>(jobs);
            ArrayList<ScoredJob> badJobList = new ArrayList<ScoredJob>();
            ScoredJob bestScoredJob = this.nextJob(routes, unassignedJobList, badJobList);
            if (bestScoredJob != null) {
                if (bestScoredJob.isNewRoute()) {
                    routes.add(bestScoredJob.getRoute());
                }
                this.insertJob(bestScoredJob.getJob(), bestScoredJob.getInsertionData(), bestScoredJob.getRoute());
                jobs.remove(bestScoredJob.getJob());
            }
            for (ScoredJob bad : badJobList) {
                Job unassigned = bad.getJob();
                jobs.remove(unassigned);
                badJobs.add(unassigned);
                this.markUnassigned(unassigned, bad.getInsertionData().getFailedConstraintNames());
            }
        }
        return badJobs;
    }

    private VehicleRoute findRoute(Collection<VehicleRoute> routes, Job job) {
        for (VehicleRoute r : routes) {
            if (r.getVehicle().getBreak() != job) continue;
            return r;
        }
        return null;
    }

    private ScoredJob nextJob(Collection<VehicleRoute> routes, Collection<Job> unassignedJobList, List<ScoredJob> badJobs) {
        ScoredJob bestScoredJob = null;
        for (Job unassignedJob : unassignedJobList) {
            ScoredJob scoredJob = RegretInsertion.getScoredJob(routes, unassignedJob, this.insertionCostsCalculator, this.scoringFunction);
            if (scoredJob instanceof ScoredJob.BadJob) {
                badJobs.add(scoredJob);
                continue;
            }
            if (bestScoredJob == null) {
                bestScoredJob = scoredJob;
                continue;
            }
            if (scoredJob.getScore() > bestScoredJob.getScore()) {
                bestScoredJob = scoredJob;
                continue;
            }
            if (scoredJob.getScore() != bestScoredJob.getScore() || scoredJob.getJob().getId().compareTo(bestScoredJob.getJob().getId()) > 0) continue;
            bestScoredJob = scoredJob;
        }
        return bestScoredJob;
    }

    static ScoredJob getScoredJob(Collection<VehicleRoute> routes, Job unassignedJob, JobInsertionCostsCalculator insertionCostsCalculator, ScoringFunction scoringFunction) {
        InsertionData best = null;
        InsertionData secondBest = null;
        VehicleRoute bestRoute = null;
        ArrayList<String> failedConstraintNames = new ArrayList<String>();
        double benchmark = Double.MAX_VALUE;
        for (VehicleRoute route : routes) {
            InsertionData iData;
            if (secondBest != null) {
                benchmark = secondBest.getInsertionCost();
            }
            if ((iData = insertionCostsCalculator.getInsertionData(route, unassignedJob, NO_NEW_VEHICLE_YET, -12345.12345, NO_NEW_DRIVER_YET, benchmark)) instanceof InsertionData.NoInsertionFound) {
                failedConstraintNames.addAll(iData.getFailedConstraintNames());
                continue;
            }
            if (best == null) {
                best = iData;
                bestRoute = route;
                continue;
            }
            if (iData.getInsertionCost() < best.getInsertionCost()) {
                secondBest = best;
                best = iData;
                bestRoute = route;
                continue;
            }
            if (secondBest != null && !(iData.getInsertionCost() < secondBest.getInsertionCost())) continue;
            secondBest = iData;
        }
        VehicleRoute emptyRoute = VehicleRoute.emptyRoute();
        InsertionData iData = insertionCostsCalculator.getInsertionData(emptyRoute, unassignedJob, NO_NEW_VEHICLE_YET, -12345.12345, NO_NEW_DRIVER_YET, benchmark);
        if (!(iData instanceof InsertionData.NoInsertionFound)) {
            if (best == null) {
                best = iData;
                bestRoute = emptyRoute;
            } else if (iData.getInsertionCost() < best.getInsertionCost()) {
                secondBest = best;
                best = iData;
                bestRoute = emptyRoute;
            } else if (secondBest == null || iData.getInsertionCost() < secondBest.getInsertionCost()) {
                secondBest = iData;
            }
        } else {
            failedConstraintNames.addAll(iData.getFailedConstraintNames());
        }
        if (best == null) {
            ScoredJob.BadJob badJob = new ScoredJob.BadJob(unassignedJob, failedConstraintNames);
            return badJob;
        }
        double score = RegretInsertion.score(unassignedJob, best, secondBest, scoringFunction);
        ScoredJob scoredJob = bestRoute == emptyRoute ? new ScoredJob(unassignedJob, score, best, bestRoute, true) : new ScoredJob(unassignedJob, score, best, bestRoute, false);
        return scoredJob;
    }

    static double score(Job unassignedJob, InsertionData best, InsertionData secondBest, ScoringFunction scoringFunction) {
        return Scorer.score(unassignedJob, best, secondBest, scoringFunction);
    }
}

