/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.recreate;

import com.graphhopper.jsprit.core.algorithm.recreate.ActivityInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.AuxilliaryCostCalculator;
import com.graphhopper.jsprit.core.algorithm.recreate.InsertionData;
import com.graphhopper.jsprit.core.algorithm.recreate.JobInsertionCostsCalculator;
import com.graphhopper.jsprit.core.algorithm.state.InternalStates;
import com.graphhopper.jsprit.core.problem.JobActivityFactory;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.constraint.HardRouteConstraint;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingActivityCosts;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingTransportCosts;
import com.graphhopper.jsprit.core.problem.driver.Driver;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.End;
import com.graphhopper.jsprit.core.problem.solution.route.activity.Start;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivities;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.problem.vehicle.VehicleImpl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
final class ServiceInsertionOnRouteLevelCalculator
implements JobInsertionCostsCalculator {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInsertionOnRouteLevelCalculator.class);
    private final VehicleRoutingTransportCosts transportCosts;
    private final VehicleRoutingActivityCosts activityCosts;
    private AuxilliaryCostCalculator auxilliaryPathCostCalculator;
    private JobActivityFactory activityFactory;
    private RouteAndActivityStateGetter stateManager;
    private HardRouteConstraint hardRouteLevelConstraint;
    private HardActivityConstraint hardActivityLevelConstraint;
    private ActivityInsertionCostsCalculator activityInsertionCostsCalculator;
    private int nuOfActsForwardLooking = 0;
    private int memorySize = 2;
    private Start start;
    private End end;

    public void setJobActivityFactory(JobActivityFactory jobActivityFactory) {
        this.activityFactory = jobActivityFactory;
    }

    public void setMemorySize(int memorySize) {
        this.memorySize = memorySize;
        logger.debug("set [solutionMemory={}]", (Object)memorySize);
    }

    public ServiceInsertionOnRouteLevelCalculator(VehicleRoutingTransportCosts vehicleRoutingCosts, VehicleRoutingActivityCosts costFunc, ActivityInsertionCostsCalculator activityInsertionCostsCalculator, HardRouteConstraint hardRouteLevelConstraint, HardActivityConstraint hardActivityLevelConstraint) {
        this.transportCosts = vehicleRoutingCosts;
        this.activityCosts = costFunc;
        this.activityInsertionCostsCalculator = activityInsertionCostsCalculator;
        this.hardRouteLevelConstraint = hardRouteLevelConstraint;
        this.hardActivityLevelConstraint = hardActivityLevelConstraint;
        this.auxilliaryPathCostCalculator = new AuxilliaryCostCalculator(this.transportCosts, this.activityCosts);
        logger.debug("initialise {}", (Object)this);
    }

    public void setStates(RouteAndActivityStateGetter stateManager) {
        this.stateManager = stateManager;
    }

    void setNuOfActsForwardLooking(int nOfActsForwardLooking) {
        this.nuOfActsForwardLooking = nOfActsForwardLooking;
        logger.debug("set [forwardLooking={}]", (Object)nOfActsForwardLooking);
    }

    public String toString() {
        return "[name=calculatesServiceInsertionOnRouteLevel][solutionMemory=" + this.memorySize + "][forwardLooking=" + this.nuOfActsForwardLooking + "]";
    }

    @Override
    public InsertionData getInsertionData(VehicleRoute currentRoute, Job jobToInsert, Vehicle newVehicle, double newVehicleDepartureTime, Driver newDriver, double best_known_insertion_costs) {
        End nextAct;
        HardActivityConstraint.ConstraintsStatus hardActivityConstraintsStatus;
        if (jobToInsert == null) {
            throw new IllegalStateException("job is null. cannot calculate the insertion of a null-job.");
        }
        if (newVehicle == null || newVehicle instanceof VehicleImpl.NoVehicle) {
            throw new IllegalStateException("no vehicle given. set para vehicle!");
        }
        JobInsertionContext insertionContext = new JobInsertionContext(currentRoute, jobToInsert, newVehicle, newDriver, newVehicleDepartureTime);
        if (!this.hardRouteLevelConstraint.fulfilled(insertionContext)) {
            return InsertionData.createEmptyInsertionData();
        }
        PriorityQueue<InsertionData> bestInsertionsQueue = new PriorityQueue<InsertionData>(Math.max(2, currentRoute.getTourActivities().getActivities().size()), this.getComparator());
        TourActivities tour = currentRoute.getTourActivities();
        double best_insertion_costs = best_known_insertion_costs;
        Service service = (Service)jobToInsert;
        TourActivity serviceAct2Insert = this.activityFactory.createActivities(service).get(0);
        int best_insertion_index = InsertionData.NO_INDEX;
        this.initialiseStartAndEnd(newVehicle, newVehicleDepartureTime);
        TourActivity prevAct = this.start;
        int actIndex = 0;
        double sumOf_prevCosts_newVehicle = 0.0;
        double prevActDepTime_newVehicle = this.start.getEndTime();
        boolean loopBroken = false;
        for (TourActivity nextAct2 : tour.getActivities()) {
            HardActivityConstraint.ConstraintsStatus hardActivityConstraintsStatus2 = this.hardActivityLevelConstraint.fulfilled(insertionContext, prevAct, serviceAct2Insert, nextAct2, prevActDepTime_newVehicle);
            if (hardActivityConstraintsStatus2.equals((Object)HardActivityConstraint.ConstraintsStatus.FULFILLED)) {
                double actInsertionCosts = this.activityInsertionCostsCalculator.getCosts(insertionContext, prevAct, nextAct2, serviceAct2Insert, prevActDepTime_newVehicle);
                double insertion_cost_approximation = sumOf_prevCosts_newVehicle - this.sumOf_prevCosts_oldVehicle(currentRoute, prevAct) + actInsertionCosts;
                if (insertion_cost_approximation < best_known_insertion_costs) {
                    bestInsertionsQueue.add(new InsertionData(insertion_cost_approximation, InsertionData.NO_INDEX, actIndex, newVehicle, newDriver));
                }
            } else if (hardActivityConstraintsStatus2.equals((Object)HardActivityConstraint.ConstraintsStatus.NOT_FULFILLED_BREAK)) {
                loopBroken = true;
                break;
            }
            double transportCost_prevAct_nextAct_newVehicle = this.transportCosts.getTransportCost(prevAct.getLocation(), nextAct2.getLocation(), prevActDepTime_newVehicle, newDriver, newVehicle);
            double transportTime_prevAct_nextAct_newVehicle = this.transportCosts.getTransportTime(prevAct.getLocation(), nextAct2.getLocation(), prevActDepTime_newVehicle, newDriver, newVehicle);
            double arrTime_nextAct_newVehicle = prevActDepTime_newVehicle + transportTime_prevAct_nextAct_newVehicle;
            double activityCost_nextAct = this.activityCosts.getActivityCost(nextAct2, arrTime_nextAct_newVehicle, newDriver, newVehicle);
            sumOf_prevCosts_newVehicle += transportCost_prevAct_nextAct_newVehicle + activityCost_nextAct;
            double depTime_nextAct_newVehicle = Math.max(arrTime_nextAct_newVehicle, nextAct2.getTheoreticalEarliestOperationStartTime()) + this.activityCosts.getActivityDuration(nextAct2, arrTime_nextAct_newVehicle, newDriver, newVehicle);
            prevAct = nextAct2;
            prevActDepTime_newVehicle = depTime_nextAct_newVehicle;
            ++actIndex;
        }
        if (!loopBroken && (hardActivityConstraintsStatus = this.hardActivityLevelConstraint.fulfilled(insertionContext, prevAct, serviceAct2Insert, nextAct = this.end, prevActDepTime_newVehicle)).equals((Object)HardActivityConstraint.ConstraintsStatus.FULFILLED)) {
            double actInsertionCosts = this.activityInsertionCostsCalculator.getCosts(insertionContext, prevAct, nextAct, serviceAct2Insert, prevActDepTime_newVehicle);
            double insertion_cost_approximation = sumOf_prevCosts_newVehicle - this.sumOf_prevCosts_oldVehicle(currentRoute, prevAct) + actInsertionCosts;
            if (insertion_cost_approximation < best_known_insertion_costs) {
                bestInsertionsQueue.add(new InsertionData(insertion_cost_approximation, InsertionData.NO_INDEX, actIndex, newVehicle, newDriver));
            }
        }
        if (this.memorySize == 0) {
            InsertionData insertion = bestInsertionsQueue.poll();
            if (insertion != null) {
                best_insertion_index = insertion.getDeliveryInsertionIndex();
                best_insertion_costs = insertion.getInsertionCost();
            }
        } else {
            for (int i = 0; i < this.memorySize; ++i) {
                double insertion_costs;
                InsertionData data = bestInsertionsQueue.poll();
                if (data == null) continue;
                ArrayList<TourActivity> wholeTour = new ArrayList<TourActivity>();
                wholeTour.add(this.start);
                wholeTour.addAll(currentRoute.getTourActivities().getActivities());
                wholeTour.add(this.end);
                wholeTour.add(data.getDeliveryInsertionIndex() + 1, serviceAct2Insert);
                Double currentRouteCosts = this.stateManager.getRouteState(currentRoute, InternalStates.COSTS, Double.class);
                if (currentRouteCosts == null) {
                    currentRouteCosts = 0.0;
                }
                if (!((insertion_costs = this.auxilliaryPathCostCalculator.costOfPath(wholeTour, this.start.getEndTime(), newDriver, newVehicle) - currentRouteCosts) < best_insertion_costs)) continue;
                best_insertion_index = data.getDeliveryInsertionIndex();
                best_insertion_costs = insertion_costs;
            }
        }
        if (best_insertion_index == InsertionData.NO_INDEX) {
            return InsertionData.createEmptyInsertionData();
        }
        InsertionData insertionData = new InsertionData(best_insertion_costs, InsertionData.NO_INDEX, best_insertion_index, newVehicle, newDriver);
        insertionData.setVehicleDepartureTime(this.start.getEndTime());
        return insertionData;
    }

    private void initialiseStartAndEnd(Vehicle newVehicle, double newVehicleDepartureTime) {
        if (this.start == null) {
            this.start = new Start(newVehicle.getStartLocation(), newVehicle.getEarliestDeparture(), Double.MAX_VALUE);
            this.start.setEndTime(newVehicleDepartureTime);
        } else {
            this.start.setLocation(Location.newInstance(newVehicle.getStartLocation().getId()));
            this.start.setTheoreticalEarliestOperationStartTime(newVehicle.getEarliestDeparture());
            this.start.setTheoreticalLatestOperationStartTime(Double.MAX_VALUE);
            this.start.setEndTime(newVehicleDepartureTime);
        }
        if (this.end == null) {
            this.end = new End(newVehicle.getEndLocation(), 0.0, newVehicle.getLatestArrival());
        } else {
            this.end.setLocation(Location.newInstance(newVehicle.getEndLocation().getId()));
            this.end.setTheoreticalEarliestOperationStartTime(0.0);
            this.end.setTheoreticalLatestOperationStartTime(newVehicle.getLatestArrival());
        }
    }

    private double sumOf_prevCosts_oldVehicle(VehicleRoute vehicleRoute, TourActivity act) {
        Double prevCost = act instanceof End ? this.stateManager.getRouteState(vehicleRoute, InternalStates.COSTS, Double.class) : this.stateManager.getActivityState(act, InternalStates.COSTS, Double.class);
        if (prevCost == null) {
            prevCost = 0.0;
        }
        return prevCost;
    }

    private Comparator<InsertionData> getComparator() {
        return new Comparator<InsertionData>(){

            @Override
            public int compare(InsertionData o1, InsertionData o2) {
                if (o1.getInsertionCost() < o2.getInsertionCost()) {
                    return -1;
                }
                return 1;
            }
        };
    }
}

