/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.ruin;

import com.graphhopper.jsprit.core.algorithm.ruin.AbstractRuinStrategy;
import com.graphhopper.jsprit.core.algorithm.ruin.RuinShareFactory;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.driver.DriverImpl;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.util.NoiseMaker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuinWorst
extends AbstractRuinStrategy {
    private Logger logger = LoggerFactory.getLogger(RuinWorst.class);
    private VehicleRoutingProblem vrp;
    private NoiseMaker noiseMaker = new NoiseMaker(){

        @Override
        public double makeNoise() {
            return 0.0;
        }
    };

    public void setNoiseMaker(NoiseMaker noiseMaker) {
        this.noiseMaker = noiseMaker;
    }

    public RuinWorst(VehicleRoutingProblem vrp, final int initialNumberJobsToRemove) {
        super(vrp);
        this.vrp = vrp;
        this.setRuinShareFactory(new RuinShareFactory(){

            @Override
            public int createNumberToBeRemoved() {
                return initialNumberJobsToRemove;
            }
        });
        this.logger.debug("initialise {}", (Object)this);
    }

    @Override
    public Collection<Job> ruinRoutes(Collection<VehicleRoute> vehicleRoutes) {
        ArrayList<Job> unassignedJobs = new ArrayList<Job>();
        int nOfJobs2BeRemoved = this.getRuinShareFactory().createNumberToBeRemoved();
        this.ruin(vehicleRoutes, nOfJobs2BeRemoved, unassignedJobs);
        return unassignedJobs;
    }

    private void ruin(Collection<VehicleRoute> vehicleRoutes, int nOfJobs2BeRemoved, List<Job> unassignedJobs) {
        Job worst;
        LinkedList<Job> availableJobs = new LinkedList<Job>(this.vrp.getJobs().values());
        for (int toRemove = nOfJobs2BeRemoved; toRemove > 0 && (worst = this.getWorst(vehicleRoutes)) != null; --toRemove) {
            if (!this.removeJob(worst, vehicleRoutes)) continue;
            availableJobs.remove(worst);
            unassignedJobs.add(worst);
        }
    }

    private Job getWorst(Collection<VehicleRoute> copied) {
        Job worst = null;
        double bestSavings = Double.MIN_VALUE;
        for (VehicleRoute route : copied) {
            if (route.isEmpty()) continue;
            HashMap<Job, Double> savingsMap = new HashMap<Job, Double>();
            TourActivity actBefore = route.getStart();
            TourActivity actToEval = null;
            for (TourActivity act : route.getActivities()) {
                if (!(act instanceof TourActivity.JobActivity)) continue;
                if (actToEval == null) {
                    actToEval = act;
                    continue;
                }
                double savings = this.savings(route, actBefore, actToEval, act);
                Job job = ((TourActivity.JobActivity)actToEval).getJob();
                if (!savingsMap.containsKey(job)) {
                    savingsMap.put(job, savings);
                } else {
                    double s = (Double)savingsMap.get(job);
                    savingsMap.put(job, s + savings);
                }
                actBefore = actToEval;
                actToEval = act;
            }
            if (actToEval == null) continue;
            double savings = this.savings(route, actBefore, actToEval, route.getEnd());
            Job job = ((TourActivity.JobActivity)actToEval).getJob();
            if (!savingsMap.containsKey(job)) {
                savingsMap.put(job, savings);
            } else {
                double s = (Double)savingsMap.get(job);
                savingsMap.put(job, s + savings);
            }
            for (Job j : savingsMap.keySet()) {
                if (!((Double)savingsMap.get(j) > bestSavings)) continue;
                bestSavings = (Double)savingsMap.get(j);
                worst = j;
            }
        }
        return worst;
    }

    private double savings(VehicleRoute route, TourActivity actBefore, TourActivity actToEval, TourActivity act) {
        double savings = this.c(actBefore, actToEval, route.getVehicle()) + this.c(actToEval, act, route.getVehicle()) - this.c(actBefore, act, route.getVehicle());
        return Math.max(0.0, savings + this.noiseMaker.makeNoise());
    }

    private double c(TourActivity from, TourActivity to, Vehicle vehicle) {
        return this.vrp.getTransportCosts().getTransportCost(from.getLocation(), to.getLocation(), from.getEndTime(), DriverImpl.noDriver(), vehicle);
    }

    public String toString() {
        return "[name=worstRuin]";
    }
}

