/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.state;

import com.graphhopper.jsprit.core.algorithm.state.StateId;
import com.graphhopper.jsprit.core.algorithm.state.StateManager;
import com.graphhopper.jsprit.core.algorithm.state.StateUpdater;
import com.graphhopper.jsprit.core.algorithm.state.UpdateVehicleDependentPracticalTimeWindows;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.cost.TransportTime;
import com.graphhopper.jsprit.core.problem.cost.VehicleRoutingActivityCosts;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ActivityVisitor;
import com.graphhopper.jsprit.core.problem.solution.route.activity.DeliveryActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.PickupActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.ServiceActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateMaxTimeInVehicle
implements StateUpdater,
ActivityVisitor {
    private Map<Integer, Map<Job, Double>> openPickupEndTimesPerVehicle = new HashMap<Integer, Map<Job, Double>>();
    private Map<Integer, Map<TourActivity, Double>> slackTimesPerVehicle = new HashMap<Integer, Map<TourActivity, Double>>();
    private Map<Integer, Map<TourActivity, Double>> actStartTimesPerVehicle = new HashMap<Integer, Map<TourActivity, Double>>();
    private VehicleRoute route;
    private final StateManager stateManager;
    private final StateId minSlackId;
    private final StateId openJobsId;
    private double[] prevActEndTimes;
    private Location[] prevActLocations;
    private Collection<Vehicle> vehicles;
    private final TransportTime transportTime;
    private final VehicleRoutingActivityCosts activityCosts;
    private UpdateVehicleDependentPracticalTimeWindows.VehiclesToUpdate vehiclesToUpdate = new UpdateVehicleDependentPracticalTimeWindows.VehiclesToUpdate(){

        @Override
        public Collection<Vehicle> get(VehicleRoute route) {
            return Arrays.asList(route.getVehicle());
        }
    };

    public UpdateMaxTimeInVehicle(StateManager stateManager, StateId slackTimeId, TransportTime transportTime, VehicleRoutingActivityCosts activityCosts, StateId openJobsId) {
        this.stateManager = stateManager;
        this.minSlackId = slackTimeId;
        this.openJobsId = openJobsId;
        this.transportTime = transportTime;
        this.prevActEndTimes = new double[stateManager.getMaxIndexOfVehicleTypeIdentifiers() + 1];
        this.prevActLocations = new Location[stateManager.getMaxIndexOfVehicleTypeIdentifiers() + 1];
        this.activityCosts = activityCosts;
    }

    public void setVehiclesToUpdate(UpdateVehicleDependentPracticalTimeWindows.VehiclesToUpdate vehiclesToUpdate) {
        this.vehiclesToUpdate = vehiclesToUpdate;
    }

    @Override
    public void begin(VehicleRoute route) {
        this.openPickupEndTimesPerVehicle.clear();
        this.slackTimesPerVehicle.clear();
        this.actStartTimesPerVehicle.clear();
        this.vehicles = this.vehiclesToUpdate.get(route);
        this.route = route;
        for (Vehicle v : this.vehicles) {
            int vehicleIndex = v.getVehicleTypeIdentifier().getIndex();
            this.openPickupEndTimesPerVehicle.put(vehicleIndex, new HashMap());
            this.slackTimesPerVehicle.put(vehicleIndex, new HashMap());
            this.actStartTimesPerVehicle.put(vehicleIndex, new HashMap());
            this.prevActEndTimes[vehicleIndex] = v.getEarliestDeparture();
            this.prevActLocations[vehicleIndex] = v.getStartLocation();
        }
    }

    @Override
    public void visit(TourActivity activity) {
        double maxTime = this.getMaxTimeInVehicle(activity);
        for (Vehicle v : this.vehicles) {
            int vehicleIndex = v.getVehicleTypeIdentifier().getIndex();
            Location prevActLocation = this.prevActLocations[vehicleIndex];
            double prevActEndTime = this.prevActEndTimes[v.getVehicleTypeIdentifier().getIndex()];
            double activityArrival = this.prevActEndTimes[v.getVehicleTypeIdentifier().getIndex()] + this.transportTime.getTransportTime(prevActLocation, activity.getLocation(), prevActEndTime, this.route.getDriver(), v);
            double activityStart = Math.max(activityArrival, activity.getTheoreticalEarliestOperationStartTime());
            this.memorizeActStart(activity, v, activityStart);
            double activityEnd = activityStart + this.activityCosts.getActivityDuration(activity, activityArrival, this.route.getDriver(), v);
            Map<Job, Double> openPickups = this.openPickupEndTimesPerVehicle.get(vehicleIndex);
            if (activity instanceof ServiceActivity || activity instanceof PickupActivity) {
                openPickups.put(((TourActivity.JobActivity)activity).getJob(), activityEnd);
            } else if (activity instanceof DeliveryActivity) {
                double pickupEnd;
                Job job = ((TourActivity.JobActivity)activity).getJob();
                if (openPickups.containsKey(job)) {
                    pickupEnd = openPickups.get(job);
                    openPickups.remove(job);
                } else {
                    pickupEnd = v.getEarliestDeparture();
                }
                double slackTime = maxTime - (activityStart - pickupEnd);
                this.slackTimesPerVehicle.get(vehicleIndex).put(activity, slackTime);
            }
            this.prevActLocations[vehicleIndex] = activity.getLocation();
            this.prevActEndTimes[vehicleIndex] = activityEnd;
        }
    }

    private double getMaxTimeInVehicle(TourActivity activity) {
        double maxTime = Double.MAX_VALUE;
        if (activity instanceof TourActivity.JobActivity) {
            maxTime = ((TourActivity.JobActivity)activity).getJob().getMaxTimeInVehicle();
        }
        return maxTime;
    }

    private void memorizeActStart(TourActivity activity, Vehicle v, double activityStart) {
        this.actStartTimesPerVehicle.get(v.getVehicleTypeIdentifier().getIndex()).put(activity, activityStart);
    }

    @Override
    public void finish() {
        for (Vehicle v : this.vehicles) {
            int vehicleIndex = v.getVehicleTypeIdentifier().getIndex();
            double routeEnd = !v.isReturnToDepot() ? this.prevActEndTimes[vehicleIndex] : this.prevActEndTimes[vehicleIndex] + this.transportTime.getTransportTime(this.prevActLocations[vehicleIndex], v.getEndLocation(), this.prevActEndTimes[vehicleIndex], this.route.getDriver(), v);
            HashMap<Job, Double> openDeliveries = new HashMap<Job, Double>();
            for (Job job : this.openPickupEndTimesPerVehicle.get(vehicleIndex).keySet()) {
                double actEndTime = this.openPickupEndTimesPerVehicle.get(vehicleIndex).get(job);
                double slackTime = job.getMaxTimeInVehicle() - (routeEnd - actEndTime);
                openDeliveries.put(job, slackTime);
            }
            double minSlackTimeAtEnd = this.minSlackTime(openDeliveries);
            this.stateManager.putRouteState(this.route, v, this.minSlackId, minSlackTimeAtEnd);
            this.stateManager.putRouteState(this.route, v, this.openJobsId, new HashMap<Job, Double>(openDeliveries));
            ArrayList<TourActivity> acts = new ArrayList<TourActivity>(this.route.getActivities());
            Collections.reverse(acts);
            for (TourActivity act : acts) {
                double minSlackTime;
                Job job = ((TourActivity.JobActivity)act).getJob();
                if (act instanceof ServiceActivity || act instanceof PickupActivity) {
                    openDeliveries.remove(job);
                    minSlackTime = this.minSlackTime(openDeliveries);
                    this.stateManager.putActivityState(act, v, this.openJobsId, new HashMap<Job, Double>(openDeliveries));
                    this.stateManager.putActivityState(act, v, this.minSlackId, minSlackTime);
                    continue;
                }
                if (this.slackTimesPerVehicle.get(vehicleIndex).containsKey(act)) {
                    double slackTime = this.slackTimesPerVehicle.get(vehicleIndex).get(act);
                    openDeliveries.put(job, slackTime);
                }
                minSlackTime = this.minSlackTime(openDeliveries);
                this.stateManager.putActivityState(act, v, this.openJobsId, new HashMap<Job, Double>(openDeliveries));
                this.stateManager.putActivityState(act, v, this.minSlackId, minSlackTime);
            }
        }
    }

    public void finish(List<TourActivity> activities, Job ignore) {
        for (Vehicle v : this.vehicles) {
            int vehicleIndex = v.getVehicleTypeIdentifier().getIndex();
            double routeEnd = !v.isReturnToDepot() ? this.prevActEndTimes[vehicleIndex] : this.prevActEndTimes[vehicleIndex] + this.transportTime.getTransportTime(this.prevActLocations[vehicleIndex], v.getEndLocation(), this.prevActEndTimes[vehicleIndex], this.route.getDriver(), v);
            HashMap<Job, Double> openDeliveries = new HashMap<Job, Double>();
            for (Job job : this.openPickupEndTimesPerVehicle.get(vehicleIndex).keySet()) {
                if (job == ignore) continue;
                double actEndTime = this.openPickupEndTimesPerVehicle.get(vehicleIndex).get(job);
                double slackTime = job.getMaxTimeInVehicle() - (routeEnd - actEndTime);
                openDeliveries.put(job, slackTime);
            }
            double minSlackTimeAtEnd = this.minSlackTime(openDeliveries);
            this.stateManager.putRouteState(this.route, v, this.minSlackId, routeEnd + minSlackTimeAtEnd);
            ArrayList<TourActivity> acts = new ArrayList<TourActivity>(activities);
            Collections.reverse(acts);
            for (TourActivity act : acts) {
                Job job = ((TourActivity.JobActivity)act).getJob();
                if (act instanceof ServiceActivity || act instanceof PickupActivity) {
                    String jobId = job.getId();
                    openDeliveries.remove(jobId);
                    double minSlackTime = this.minSlackTime(openDeliveries);
                    double latestStart = this.actStart(act, v) + minSlackTime;
                    this.stateManager.putActivityState(act, v, this.minSlackId, latestStart);
                    continue;
                }
                if (this.slackTimesPerVehicle.get(vehicleIndex).containsKey(act)) {
                    double slackTime = this.slackTimesPerVehicle.get(vehicleIndex).get(act);
                    openDeliveries.put(job, slackTime);
                }
                double minSlackTime = this.minSlackTime(openDeliveries);
                double latestStart = this.actStart(act, v) + minSlackTime;
                this.stateManager.putActivityState(act, v, this.minSlackId, latestStart);
            }
        }
    }

    private double actStart(TourActivity act, Vehicle v) {
        return this.actStartTimesPerVehicle.get(v.getVehicleTypeIdentifier().getIndex()).get(act);
    }

    private double minSlackTime(Map<Job, Double> openDeliveries) {
        double min = Double.MAX_VALUE;
        for (Double value : openDeliveries.values()) {
            if (!(value < min)) continue;
            min = value;
        }
        return min;
    }
}

