/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.algorithm.termination;

import com.graphhopper.jsprit.core.algorithm.SearchStrategy;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.listener.AlgorithmStartsListener;
import com.graphhopper.jsprit.core.algorithm.termination.PrematureAlgorithmTermination;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTermination
implements PrematureAlgorithmTermination,
AlgorithmStartsListener {
    private static Logger logger = LoggerFactory.getLogger(TimeTermination.class);
    private final long timeThreshold;
    private TimeGetter timeGetter = System::currentTimeMillis;
    private long startTime;

    public TimeTermination(long timeThreshold_in_milliseconds) {
        this.timeThreshold = timeThreshold_in_milliseconds;
        logger.debug("initialise {}", (Object)this);
    }

    public void setTimeGetter(TimeGetter timeGetter) {
        this.timeGetter = timeGetter;
    }

    public String toString() {
        return "[name=TimeTermination][timeThreshold=" + this.timeThreshold + " ms]";
    }

    @Override
    public boolean isPrematureBreak(SearchStrategy.DiscoveredSolution discoveredSolution) {
        return this.now() - this.startTime > this.timeThreshold;
    }

    void start(long startTime) {
        this.startTime = startTime;
    }

    public long now() {
        return this.timeGetter.getCurrentTime();
    }

    @Override
    public void informAlgorithmStarts(VehicleRoutingProblem problem, VehicleRoutingAlgorithm algorithm, Collection<VehicleRoutingProblemSolution> solutions) {
        this.start(this.timeGetter.getCurrentTime());
    }

    public long getRemainingTime() {
        return this.timeThreshold - (this.now() - this.startTime);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public static interface TimeGetter {
        public long getCurrentTime();
    }
}

