/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem;

import com.graphhopper.jsprit.core.problem.HasId;
import com.graphhopper.jsprit.core.problem.HasIndex;
import com.graphhopper.jsprit.core.util.Coordinate;

public final class Location
implements HasIndex,
HasId {
    public static final int NO_INDEX = -1;
    private final int index;
    private final Coordinate coordinate;
    private final String id;
    private final String name;
    private Object userData;

    public static Location newInstance(double x, double y) {
        return Builder.newInstance().setCoordinate(Coordinate.newInstance(x, y)).build();
    }

    public static Location newInstance(String id) {
        return Builder.newInstance().setId(id).build();
    }

    public static Location newInstance(int index) {
        return Builder.newInstance().setIndex(index).build();
    }

    private Location(Builder builder) {
        this.userData = builder.userData;
        this.index = builder.index;
        this.coordinate = builder.coordinate;
        this.id = builder.id;
        this.name = builder.name;
    }

    public Object getUserData() {
        return this.userData;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location location = (Location)o;
        if (this.index != location.index) {
            return false;
        }
        if (this.coordinate != null ? !this.coordinate.equals(location.coordinate) : location.coordinate != null) {
            return false;
        }
        return this.id != null ? this.id.equals(location.id) : location.id == null;
    }

    public int hashCode() {
        int result = this.index;
        result = 31 * result + (this.coordinate != null ? this.coordinate.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "[id=" + this.id + "][index=" + this.index + "][coordinate=" + this.coordinate + "]";
    }

    public static class Builder {
        private String id;
        private int index = -1;
        private Coordinate coordinate;
        private String name = "";
        private Object userData;

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder setUserData(Object userData) {
            this.userData = userData;
            return this;
        }

        public Builder setIndex(int index) {
            if (index < 0) {
                throw new IllegalArgumentException("index must be >= 0");
            }
            this.index = index;
            return this;
        }

        public Builder setCoordinate(Coordinate coordinate) {
            this.coordinate = coordinate;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Location build() {
            if (this.id == null && this.coordinate == null && this.index == -1) {
                throw new IllegalArgumentException("either id or coordinate or index must be set");
            }
            if (this.coordinate != null && this.id == null) {
                this.id = this.coordinate.toString();
            }
            if (this.index != -1 && this.id == null) {
                this.id = Integer.toString(this.index);
            }
            return new Location(this);
        }
    }
}

