/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.core.problem.constraint;

import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.constraint.Constraint;
import com.graphhopper.jsprit.core.problem.constraint.DependencyType;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityConstraint;
import com.graphhopper.jsprit.core.problem.constraint.HardActivityLevelConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.HardRouteConstraint;
import com.graphhopper.jsprit.core.problem.constraint.HardRouteLevelConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.HardSkillConstraint;
import com.graphhopper.jsprit.core.problem.constraint.PickupAndDeliverShipmentLoadActivityLevelConstraint;
import com.graphhopper.jsprit.core.problem.constraint.ServiceLoadActivityLevelConstraint;
import com.graphhopper.jsprit.core.problem.constraint.ServiceLoadRouteLevelConstraint;
import com.graphhopper.jsprit.core.problem.constraint.SoftActivityConstraint;
import com.graphhopper.jsprit.core.problem.constraint.SoftActivityConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.SoftRouteConstraint;
import com.graphhopper.jsprit.core.problem.constraint.SoftRouteConstraintManager;
import com.graphhopper.jsprit.core.problem.constraint.VehicleDependentTimeWindowConstraints;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.misc.JobInsertionContext;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.solution.route.state.RouteAndActivityStateGetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintManager
implements HardActivityConstraint,
HardRouteConstraint,
SoftActivityConstraint,
SoftRouteConstraint {
    private static Logger log = LoggerFactory.getLogger(ConstraintManager.class);
    private HardActivityLevelConstraintManager actLevelConstraintManager = new HardActivityLevelConstraintManager();
    private HardRouteLevelConstraintManager hardRouteConstraintManager = new HardRouteLevelConstraintManager();
    private SoftActivityConstraintManager softActivityConstraintManager = new SoftActivityConstraintManager();
    private SoftRouteConstraintManager softRouteConstraintManager = new SoftRouteConstraintManager();
    private VehicleRoutingProblem vrp;
    private RouteAndActivityStateGetter stateManager;
    private boolean loadConstraintsSet = false;
    private boolean timeWindowConstraintsSet = false;
    private boolean skillconstraintSet = false;
    private final DependencyType[] dependencyTypes;

    public ConstraintManager(VehicleRoutingProblem vrp, RouteAndActivityStateGetter stateManager) {
        this.vrp = vrp;
        this.stateManager = stateManager;
        this.dependencyTypes = new DependencyType[vrp.getJobs().size() + 1];
    }

    public ConstraintManager(VehicleRoutingProblem vrp, RouteAndActivityStateGetter stateManager, Collection<Constraint> constraints) {
        this.vrp = vrp;
        this.stateManager = stateManager;
        this.dependencyTypes = new DependencyType[vrp.getJobs().size() + 1];
        this.resolveConstraints(constraints);
    }

    public Collection<HardRouteConstraint> getHardRouteConstraints() {
        return this.hardRouteConstraintManager.getConstraints();
    }

    public Collection<HardActivityConstraint> getCriticalHardActivityConstraints() {
        return this.actLevelConstraintManager.getCriticalConstraints();
    }

    public Collection<HardActivityConstraint> getHighPrioHardActivityConstraints() {
        return this.actLevelConstraintManager.getHighPrioConstraints();
    }

    public Collection<HardActivityConstraint> getLowPrioHardActivityConstraints() {
        return this.actLevelConstraintManager.getLowPrioConstraints();
    }

    public DependencyType[] getDependencyTypes() {
        return this.dependencyTypes;
    }

    public void setDependencyType(String jobId, DependencyType dependencyType) {
        Job job = this.vrp.getJobs().get(jobId);
        if (job != null) {
            this.dependencyTypes[job.getIndex()] = dependencyType;
        }
    }

    public DependencyType getDependencyType(String jobId) {
        Job job = this.vrp.getJobs().get(jobId);
        if (job != null) {
            return this.dependencyTypes[job.getIndex()];
        }
        return DependencyType.NO_TYPE;
    }

    private void resolveConstraints(Collection<Constraint> constraints) {
        for (Constraint c : constraints) {
            boolean constraintTypeKnown = false;
            if (c instanceof HardActivityConstraint) {
                this.actLevelConstraintManager.addConstraint((HardActivityConstraint)c, Priority.HIGH);
                constraintTypeKnown = true;
            }
            if (c instanceof HardRouteConstraint) {
                this.hardRouteConstraintManager.addConstraint((HardRouteConstraint)c);
                constraintTypeKnown = true;
            }
            if (c instanceof SoftRouteConstraint) {
                this.softRouteConstraintManager.addConstraint((SoftRouteConstraint)c);
                constraintTypeKnown = true;
            }
            if (c instanceof SoftActivityConstraint) {
                this.softActivityConstraintManager.addConstraint((SoftActivityConstraint)c);
                constraintTypeKnown = true;
            }
            if (constraintTypeKnown) continue;
            log.warn("constraint " + c + " unknown thus ignores the constraint. currently, a constraint must implement either HardActivityStateLevelConstraint or HardRouteStateLevelConstraint");
        }
    }

    public void addTimeWindowConstraint() {
        if (!this.timeWindowConstraintsSet) {
            this.addConstraint(new VehicleDependentTimeWindowConstraints(this.stateManager, this.vrp.getTransportCosts(), this.vrp.getActivityCosts()), Priority.HIGH);
            this.timeWindowConstraintsSet = true;
        }
    }

    public void addLoadConstraint() {
        if (!this.loadConstraintsSet) {
            this.addConstraint(new PickupAndDeliverShipmentLoadActivityLevelConstraint(this.stateManager), Priority.CRITICAL);
            this.addConstraint(new ServiceLoadRouteLevelConstraint(this.stateManager));
            this.addConstraint(new ServiceLoadActivityLevelConstraint(this.stateManager), Priority.LOW);
            this.loadConstraintsSet = true;
        }
    }

    public void addSkillsConstraint() {
        if (!this.skillconstraintSet) {
            this.addConstraint(new HardSkillConstraint(this.stateManager));
            this.skillconstraintSet = true;
        }
    }

    public void addConstraint(HardActivityConstraint actLevelConstraint, Priority priority) {
        this.actLevelConstraintManager.addConstraint(actLevelConstraint, priority);
    }

    public void addConstraint(HardRouteConstraint routeLevelConstraint) {
        this.hardRouteConstraintManager.addConstraint(routeLevelConstraint);
    }

    public void addConstraint(SoftActivityConstraint softActivityConstraint) {
        this.softActivityConstraintManager.addConstraint(softActivityConstraint);
    }

    public void addConstraint(SoftRouteConstraint softRouteConstraint) {
        this.softRouteConstraintManager.addConstraint(softRouteConstraint);
    }

    @Override
    public boolean fulfilled(JobInsertionContext insertionContext) {
        return this.hardRouteConstraintManager.fulfilled(insertionContext);
    }

    @Override
    public HardActivityConstraint.ConstraintsStatus fulfilled(JobInsertionContext iFacts, TourActivity prevAct, TourActivity newAct, TourActivity nextAct, double prevActDepTime) {
        return this.actLevelConstraintManager.fulfilled(iFacts, prevAct, newAct, nextAct, prevActDepTime);
    }

    public Collection<Constraint> getConstraints() {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        constraints.addAll(this.actLevelConstraintManager.getAllConstraints());
        constraints.addAll(this.hardRouteConstraintManager.getConstraints());
        constraints.addAll(this.softActivityConstraintManager.getConstraints());
        constraints.addAll(this.softRouteConstraintManager.getConstraints());
        return Collections.unmodifiableCollection(constraints);
    }

    @Override
    public double getCosts(JobInsertionContext insertionContext) {
        return this.softRouteConstraintManager.getCosts(insertionContext);
    }

    @Override
    public double getCosts(JobInsertionContext iFacts, TourActivity prevAct, TourActivity newAct, TourActivity nextAct, double prevActDepTime) {
        return this.softActivityConstraintManager.getCosts(iFacts, prevAct, newAct, nextAct, prevActDepTime);
    }

    public static enum Priority {
        CRITICAL,
        HIGH,
        LOW;

    }
}

